/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Job;
import java.util.List;

public class JobWithDetails
extends Job {
    String displayName;
    List<Build> builds;
    Build lastBuild;
    Build lastCompletedBuild;
    Build lastFailedBuild;
    Build lastStableBuild;
    Build lastSuccessfulBuild;
    Build lastUnstableBuild;
    Build lastUnsuccessfulBuild;
    int nextBuildNumber;
    List<Job> downstreamProjects;
    List<Job> upstreamProjects;

    public String getDisplayName() {
        return this.displayName;
    }

    public List<Build> getBuilds() {
        return Lists.transform(this.builds, (Function)new Function<Build, Build>(){

            public Build apply(Build from) {
                return JobWithDetails.this.buildWithClient(from);
            }
        });
    }

    private Build buildWithClient(Build from) {
        Build ret = new Build(from);
        ret.setClient(this.client);
        return ret;
    }

    public Build getLastBuild() {
        return this.buildWithClient(this.lastBuild);
    }

    public Build getLastCompletedBuild() {
        return this.buildWithClient(this.lastCompletedBuild);
    }

    public Build getLastFailedBuild() {
        return this.buildWithClient(this.lastFailedBuild);
    }

    public Build getLastStableBuild() {
        return this.buildWithClient(this.lastStableBuild);
    }

    public Build getLastSuccessfulBuild() {
        return this.buildWithClient(this.lastSuccessfulBuild);
    }

    public Build getLastUnstableBuild() {
        return this.buildWithClient(this.lastUnstableBuild);
    }

    public Build getLastUnsuccessfulBuild() {
        return this.buildWithClient(this.lastUnsuccessfulBuild);
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public List<Job> getDownstreamProjects() {
        return Lists.transform(this.downstreamProjects, (Function)new JobWithClient());
    }

    public List<Job> getUpstreamProjects() {
        return Lists.transform(this.upstreamProjects, (Function)new JobWithClient());
    }

    private class JobWithClient
    implements Function<Job, Job> {
        private JobWithClient() {
        }

        public Job apply(Job job) {
            job.setClient(JobWithDetails.this.client);
            return job;
        }
    }
}

