/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobConfiguration;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.LabelWithDetails;
import com.offbytwo.jenkins.model.MainView;
import com.offbytwo.jenkins.model.MavenJobWithDetails;
import com.offbytwo.jenkins.model.View;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.http.client.HttpResponseException;
import org.dom4j.DocumentException;

public class JenkinsServer {
    private final JenkinsHttpClient client;

    public JenkinsServer(URI serverUri) {
        this(new JenkinsHttpClient(serverUri));
    }

    public JenkinsServer(URI serverUri, String username, String passwordOrToken) {
        this(new JenkinsHttpClient(serverUri, username, passwordOrToken));
    }

    public JenkinsServer(JenkinsHttpClient client) {
        this.client = client;
    }

    public boolean isRunning() {
        try {
            this.client.get("/");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Map<String, Job> getJobs() throws IOException {
        List<Job> jobs = this.client.get("/", MainView.class).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public View getView(String name) throws IOException {
        return this.client.get("/view/" + this.encode(name) + "/", View.class);
    }

    public Map<String, Job> getJobs(String view) throws IOException {
        List<Job> jobs = this.client.get("/view/" + this.encode(view) + "/", View.class).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public JobWithDetails getJob(String jobName) throws IOException {
        try {
            JobWithDetails job = this.client.get("/job/" + this.encode(jobName), JobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public MavenJobWithDetails getMavenJob(String jobName) throws IOException {
        try {
            MavenJobWithDetails job = this.client.get("/job/" + this.encode(jobName), MavenJobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void createJob(String jobName, String jobXml) throws IOException {
        this.client.post_xml("/createItem?name=" + this.encode(jobName), jobXml);
    }

    public String getJobXml(String jobName) throws IOException {
        return this.client.get("/job/" + this.encode(jobName) + "/config.xml");
    }

    public LabelWithDetails getLabel(String labelName) throws IOException {
        return this.client.get("/label/" + this.encode(labelName), LabelWithDetails.class);
    }

    public Map<String, Computer> getComputers() throws IOException {
        List<Computer> computers = this.client.get("computer/", Computer.class).getComputers();
        return Maps.uniqueIndex(computers, (Function)new Function<Computer, String>(){

            public String apply(Computer computer) {
                computer.setClient(JenkinsServer.this.client);
                return computer.getDisplayName().toLowerCase();
            }
        });
    }

    public void updateJob(String jobName, String jobXml) throws IOException {
        this.updateJob(jobName, jobXml, true);
    }

    public void updateJob(String jobName, String jobXml, boolean crumbFlag) throws IOException {
        this.client.post_xml("/job/" + this.encode(jobName) + "/config.xml", jobXml, crumbFlag);
    }

    public void addStringParam(String jobName, String name, String description, String defaultValue) throws IOException, JAXBException, DocumentException {
        String jobXml = this.getJobXml(jobName);
        JobConfiguration jobConf = new JobConfiguration(jobXml);
        jobXml = jobConf.addStringParam(name, description, defaultValue).asXml();
        this.updateJob(jobName, jobXml);
    }

    public void deleteJob(String jobName) throws IOException {
        this.client.post("/job/" + this.encode(jobName) + "/doDelete");
    }

    private String encode(String pathPart) {
        return URLEncoder.encode(pathPart).replaceAll("\\+", "%20");
    }
}

