/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.offbytwo.jenkins.client.PreemptiveAuth;
import com.offbytwo.jenkins.client.util.HttpResponseContentExtractor;
import com.offbytwo.jenkins.client.validator.HttpResponseValidator;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.Crumb;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class JenkinsHttpClient {
    private URI uri;
    private DefaultHttpClient client;
    private BasicHttpContext localContext;
    private HttpResponseValidator httpResponseValidator;
    private HttpResponseContentExtractor contentExtractor;
    private ObjectMapper mapper;
    private String context;

    public JenkinsHttpClient(URI uri, DefaultHttpClient defaultHttpClient) {
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        this.client = defaultHttpClient;
        this.httpResponseValidator = new HttpResponseValidator();
        this.contentExtractor = new HttpResponseContentExtractor();
    }

    public JenkinsHttpClient(URI uri) {
        this(uri, new DefaultHttpClient());
    }

    public JenkinsHttpClient(URI uri, String username, String password) {
        this(uri);
        if (StringUtils.isNotBlank((String)username)) {
            CredentialsProvider provider = this.client.getCredentialsProvider();
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(scope, (Credentials)credentials);
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
            this.client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T get(String path, Class<T> cls) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        HttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse(response);
            T t = this.objectFromResponse(cls, response);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String path) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        HttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse(response);
            String string = this.contentExtractor.contentAsString(response);
            return string;
        }
        finally {
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFile(URI path) throws IOException {
        HttpGet getMethod = new HttpGet(path);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext);
            this.httpResponseValidator.validateResponse(response);
            InputStream inputStream = this.contentExtractor.contentAsInputStream(response);
            return inputStream;
        }
        finally {
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls) throws IOException {
        HttpPost request = new HttpPost(this.api(path));
        Crumb crumb = this.get("/crumbIssuer", Crumb.class);
        if (crumb != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (data != null) {
            StringEntity stringEntity = new StringEntity(this.mapper.writeValueAsString(data), "application/json");
            request.setEntity((HttpEntity)stringEntity);
        }
        HttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        try {
            this.httpResponseValidator.validateResponse(response);
            if (cls != null) {
                R r = this.objectFromResponse(cls, response);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public String post_xml(String path, String xml_data) throws IOException {
        return this.post_xml(path, xml_data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_xml(String path, String xml_data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (xml_data != null) {
            request.setEntity((HttpEntity)new StringEntity(xml_data, ContentType.create((String)"text/xml", (String)"utf-8")));
        }
        HttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext);
        this.httpResponseValidator.validateResponse(response);
        try {
            String string = this.contentExtractor.contentAsString(response);
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public void post(String path) throws IOException {
        this.post(path, null, null);
    }

    private String urlJoin(String path1, String path2) {
        if (!path1.endsWith("/")) {
            path1 = path1 + "/";
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        return path1 + path2;
    }

    private URI api(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        if (!path.contains("?")) {
            path = this.urlJoin(path, "api/json");
        } else {
            String[] components = path.split("\\?", 2);
            path = this.urlJoin(components[0], "api/json") + "?" + components[1];
        }
        return this.uri.resolve("/").resolve(path);
    }

    private <T extends BaseModel> T objectFromResponse(Class<T> cls, HttpResponse response) throws IOException {
        InputStream content = this.contentExtractor.contentAsInputStream(response);
        BaseModel result = (BaseModel)this.mapper.readValue(content, cls);
        result.setClient(this);
        return (T)result;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        httpRequestBase.releaseConnection();
    }
}

