/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.offbytwo.jenkins.model.Artifact;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildWithDetails
extends Build {
    List actions;
    boolean building;
    String description;
    int duration;
    int estimatedDuration;
    String fullDisplayName;
    String id;
    long timestamp;
    BuildResult result;
    List<Artifact> artifacts;
    String consoleOutputText;
    String consoleOutputHtml;

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public String getFullDisplayName() {
        return this.fullDisplayName;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public List getActions() {
        return this.actions;
    }

    public Map<String, String> getParameters() {
        Collection parameters = Collections2.filter((Collection)this.actions, (Predicate)new Predicate<Map<String, Object>>(){

            public boolean apply(Map<String, Object> action) {
                return action.containsKey("parameters");
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map param : (List)((Map)parameters.toArray()[0]).get("parameters")) {
                String key = (String)param.get("name");
                String value = (String)param.get("value");
                params.put(key, value);
            }
        }
        return params;
    }

    public String getConsoleOutputText() throws IOException {
        return this.client.get(this.url + "/logText/progressiveText");
    }

    public String getConsoleOutputHtml() throws IOException {
        return this.client.get(this.url + "/logText/progressiveHtml");
    }

    public InputStream downloadArtifact(Artifact a) throws IOException, URISyntaxException {
        URI uri = new URI(this.getUrl());
        String artifactPath = uri.getPath() + "artifact/" + a.getRelativePath();
        URI artifactUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), artifactPath, "", "");
        return this.client.getFile(artifactUri);
    }
}

