package com.ohmdb.filestore;

/*
 * #%L
 * ohmdb-core
 * %%
 * Copyright (C) 2013 - 2014 Nikolche Mihajlovski
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StoreInfo {

	private final Map<String, PersistInfo> infos = new HashMap<String, PersistInfo>();

	public synchronized PersistInfo getInfo(Object key) {
		String str = String.valueOf(key);

		PersistInfo info = infos.get(str);

		if (info == null) {
			info = new PersistInfo();
			infos.put(str, info);
		}

		return info;
	}

	public synchronized Collection<PersistInfo> entries() {
		return infos.values();
	}

}
