/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.bean;

import com.ohmdb.bean.BeanInfo;
import com.ohmdb.bean.PropertyInfo;
import com.ohmdb.util.Errors;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanIntrospector {
    private final Map<Class<?>, BeanInfo> cache = new HashMap();

    public BeanInfo describe(Class<?> clazz) {
        BeanInfo info = this.cache.get(clazz);
        if (info == null) {
            info = new BeanInfo();
            try {
                int modif;
                Class<?> c;
                for (c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
                    Method[] methods = c.getDeclaredMethods();
                    for (AccessibleObject accessibleObject : methods) {
                        String name;
                        modif = ((Method)accessibleObject).getModifiers();
                        if ((modif & 1) <= 0 || (modif & 8) != 0 || (modif & 0x400) != 0 || !(name = ((Method)accessibleObject).getName()).matches("^(get|set|is)[A-Z].*")) continue;
                        String fieldName = name.startsWith("is") ? name.substring(2, 3).toLowerCase() + name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
                        PropertyInfo propInfo = this.propInfo(info, fieldName);
                        if (name.startsWith("set")) {
                            propInfo.setSetter((Method)accessibleObject);
                            ((Method)accessibleObject).setAccessible(true);
                            continue;
                        }
                        propInfo.setGetter((Method)accessibleObject);
                        ((Method)accessibleObject).setAccessible(true);
                    }
                    Iterator<Map.Entry<String, PropertyInfo>> it = info.getProperties().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, PropertyInfo> entry = it.next();
                        PropertyInfo minfo = entry.getValue();
                        if (minfo.getGetter() != null && minfo.getSetter() != null) continue;
                        it.remove();
                    }
                }
                for (c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
                    Field[] fields = c.getDeclaredFields();
                    for (AccessibleObject accessibleObject : fields) {
                        String fieldName;
                        PropertyInfo propInfo;
                        modif = ((Field)accessibleObject).getModifiers();
                        if ((modif & 1) <= 0 || (modif & 0x10) != 0 || (modif & 8) != 0 || (propInfo = this.propInfo(info, fieldName = ((Field)accessibleObject).getName())).getGetter() != null || propInfo.getSetter() != null) continue;
                        ((Field)accessibleObject).setAccessible(true);
                        propInfo.setField((Field)accessibleObject);
                    }
                }
            }
            catch (Exception e) {
                throw Errors.rte((Throwable)e);
            }
            this.cache.put(clazz, info);
        }
        return info;
    }

    private PropertyInfo propInfo(BeanInfo info, String fieldName) {
        if (fieldName.equals("id")) {
            PropertyInfo idtor = info.getIdtor();
            if (idtor == null) {
                idtor = new PropertyInfo();
                info.setIdtor(idtor);
            }
            return idtor;
        }
        return info.getInfo(fieldName);
    }
}

