/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.bean;

import com.ohmdb.abstracts.Column;
import com.ohmdb.abstracts.ComplexIndex;
import com.ohmdb.abstracts.Index;
import com.ohmdb.abstracts.Prop;
import com.ohmdb.api.Transformer;
import com.ohmdb.util.Errors;
import com.ohmdb.util.TypeKind;
import com.ohmdb.util.U;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class PropertyInfo
implements Prop {
    private String name;
    private Field field;
    private Method getter;
    private Method setter;
    private Column column;
    private Index index;
    private Transformer<Object> transformer;
    private Class<?> type;
    private TypeKind kind;
    private Set<ComplexIndex<?>> complexIndices = new HashSet();

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public String toString() {
        return "PropertyInfo [field=" + (this.field != null ? this.field.getName() : null) + ", getter=" + (this.getter != null ? this.getter.getName() : null) + ", setter=" + (this.setter != null ? this.setter.getName() : null) + "]";
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object get(Object obj) {
        try {
            if (this.field != null) {
                return this.field.get(obj);
            }
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw Errors.rte((Throwable)e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            if (this.field != null) {
                this.field.set(obj, value);
            } else {
                this.setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            throw Errors.rte((Throwable)e);
        }
    }

    public Class<?> getType() {
        if (this.type == null) {
            this.type = this.field != null ? this.field.getType() : this.getter.getReturnType();
        }
        return this.type;
    }

    public TypeKind getKind() {
        if (this.kind == null) {
            this.kind = U.kindOf(this.getType());
        }
        return this.kind;
    }

    public Transformer<Object> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer<Object> transformer) {
        this.transformer = transformer;
    }

    public void addComplexIndex(ComplexIndex<?> index) {
        this.complexIndices.add(index);
    }

    public void appendComplexIndices(ComplexIndex<?>[] indices) {
        for (ComplexIndex<?> indx : this.complexIndices) {
            this.appendIndex(indices, indx);
        }
    }

    private void appendIndex(ComplexIndex<?>[] indices, ComplexIndex<?> indx) {
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == null) {
                indices[i] = indx;
                return;
            }
            if (indices[i] != indx) continue;
            return;
        }
        throw Errors.rte((String)"Too many indices!", (Object[])new Object[0]);
    }

    public boolean isEnum() {
        return Enum.class.isAssignableFrom(this.getType());
    }
}

