/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.filestore;

import com.ohmdb.abstracts.DataStore;
import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.abstracts.Zones;
import com.ohmdb.api.Db;
import com.ohmdb.api.TransactionListener;
import com.ohmdb.codec.StoreCodec;
import com.ohmdb.filestore.AbstractDataStore;
import com.ohmdb.filestore.BufferFullException;
import com.ohmdb.filestore.DbStats;
import com.ohmdb.filestore.FilestoreTransaction;
import com.ohmdb.filestore.KeyAndSize;
import com.ohmdb.filestore.PersistInfo;
import com.ohmdb.filestore.StoreInfo;
import com.ohmdb.filestore.StoreLoader;
import com.ohmdb.filestore.VersionInfo;
import com.ohmdb.filestore.ZonesImpl;
import com.ohmdb.impl.OhmDBImpl;
import com.ohmdb.impl.OhmDBStats;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class FileStore
extends AbstractDataStore
implements DataStore,
Runnable {
    private static final String MARK = "OhmDB";
    private static final String MARK2 = "BEGIN";
    public static final int BLOCK_OVERHEAD = 32;
    public static final int FIRST_CAP = 32;
    public static final int BLOCK_SIZE = 64;
    protected static final int BUF_SIZE = FileStore.bufSize() * 1024 * 1024;
    protected static final int MAX_BLOCKS = BUF_SIZE / 64;
    protected static final int HEADER_SIZE = 1024;
    private static final int BASE_ADDRESS = 1024;
    private static final long TX_FREE_SPACE = -1L;
    private static final int TX_MAX_COUNT = 100000;
    private final ByteBuffer BUF = ByteBuffer.allocateDirect(BUF_SIZE);
    private final ByteBuffer READ_BUF;
    private final byte[] READ_ITEM_ARR = new byte[BUF_SIZE];
    private final ByteBuffer READ_ITEM_BUF = ByteBuffer.wrap(this.READ_ITEM_ARR);
    private final ByteBuffer TX_BUF = ByteBuffer.allocateDirect(24);
    private final ByteBuffer BUF16 = ByteBuffer.allocateDirect(16);
    private final Zones zones = new ZonesImpl();
    private final StoreInfo infos = new StoreInfo();
    private final String filename;
    private final StoreCodec<Object> valueCodec;
    private AtomicLong txCounter = new AtomicLong();
    private boolean firstTxCounter = true;
    private final Map<DbStats, Object> dbstats = new HashMap<DbStats, Object>();
    private final OhmDBStats stats;
    private final Thread thread;
    int totalBlocks = 0;
    int errorBlocks = 0;
    private Queue<DatastoreTransaction> txs = new ArrayBlockingQueue<DatastoreTransaction>(100000);
    private int aggregatedSize;
    private final List<KeyAndSize> aggregatedKeys = new ArrayList<KeyAndSize>(100000);
    protected AtomicBoolean finished = new AtomicBoolean();
    private final RandomAccessFile file;
    private final WeakReference<Db> dbRef;

    public FileStore(String filename, StoreLoader loader, StoreCodec<?> valueCodec, OhmDBStats stats, boolean loadOnly, WeakReference<Db> dbRef) {
        this.filename = filename;
        this.valueCodec = valueCodec;
        this.stats = stats;
        this.dbRef = dbRef;
        assert (this.BUF.capacity() % 64 == 0);
        File dbFile = new File(filename);
        if (dbFile.exists()) {
            int sizeKB = (int)(dbFile.length() / 1024L);
            Check.state((sizeKB >= 0 ? 1 : 0) != 0, (String)"Database file is too big!", (Object[])new Object[0]);
            this.print(String.format("Loading database from: %s (%s KB)...", filename, sizeKB));
            this.READ_BUF = ByteBuffer.allocateDirect((sizeKB + 2) * 1024);
            long time = System.currentTimeMillis();
            this.loadData(loader);
            this.print(String.format("Database loaded in %s ms", System.currentTimeMillis() - time));
        } else {
            this.READ_BUF = null;
            this.print("Creating database: " + filename + "...");
        }
        if (!loadOnly) {
            try {
                this.file = new RandomAccessFile(filename, "rw");
                this.startWriting();
            }
            catch (IOException e) {
                throw Errors.rte((String)("Cannot open file: " + filename), (Throwable)e);
            }
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.thread = null;
            this.file = null;
        }
        this.print("Database is ready.");
    }

    private static int bufSize() {
        String size = System.getenv("OHMDB_BUF");
        if (size == null) {
            size = System.getProperty("OHMDB_BUF");
        }
        int n = size != null ? Integer.parseInt(size) : 1;
        System.out.println("Buffer size: " + n + " MB");
        return n;
    }

    private OhmDBImpl db() {
        return (OhmDBImpl)(this.dbRef != null ? (Db)this.dbRef.get() : null);
    }

    private void createDb() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(1024);
        this.writeHeader(buf);
        buf.rewind();
        this.write(this.file, buf, 1024);
    }

    private void writeHeader(ByteBuffer buf) {
        buf.put(MARK.getBytes());
        buf.putInt(1);
        buf.putLong(0L);
        buf.putLong(0L);
        buf.putLong(0L);
        buf.putLong(0L);
        buf.putLong(0L);
        buf.putLong(0L);
        buf.position(1024 - MARK2.length());
        buf.put(MARK2.getBytes());
    }

    private void loadHeader(RandomAccessFile fc) throws IOException {
        int read;
        this.dbstats.clear();
        ByteBuffer buf = ByteBuffer.allocateDirect(1024);
        long n = 0L;
        do {
            read = fc.getChannel().read(buf);
            n += (long)read;
        } while (read > 0);
        assert (n == 1024L);
        Check.state((n == 1024L ? 1 : 0) != 0, (String)"The file doesn't have a valid OhmDB format!", (Object[])new Object[0]);
        this.dbstats.put(DbStats.HEADER_SIZE, n);
        buf.rewind();
        String mark = this.readStr(buf, MARK.length());
        Check.state((boolean)mark.equals(MARK), (String)"The file doesn't have a valid OhmDB format (incorrect mark)!", (Object[])new Object[0]);
        int fileVersion = buf.getInt();
        Check.state((fileVersion == 1 ? 1 : 0) != 0, (String)"Unsupported OhmDB file format version: %s", (Object[])new Object[]{fileVersion});
        this.dbstats.put(DbStats.FILE_VERSION, fileVersion);
        long oddTx1 = buf.getLong();
        long oddTx2 = buf.getLong();
        long oddTx3 = buf.getLong();
        long evenTx1 = buf.getLong();
        long evenTx2 = buf.getLong();
        long evenTx3 = buf.getLong();
        long latestTx = 0L;
        if (oddTx1 == oddTx2 && oddTx2 == oddTx3 && oddTx1 > latestTx) {
            latestTx = oddTx1;
            this.firstTxCounter = false;
        }
        if (evenTx1 == evenTx2 && evenTx2 == evenTx3 && evenTx1 > latestTx) {
            latestTx = evenTx1;
            this.firstTxCounter = true;
        }
        Long[] commited = new Long[]{oddTx1, oddTx2, oddTx3, evenTx1, evenTx2, evenTx3};
        this.dbstats.put(DbStats.COMMITED, Arrays.asList(commited));
        this.dbstats.put(DbStats.LATEST_TRANSACTION, latestTx);
        this.txCounter.set(latestTx);
        this.dbstats.put(DbStats.BLOCK_SIZE, 64);
        buf.position(1024 - MARK2.length());
        String mark2 = this.readStr(buf, MARK2.length());
        Check.state((boolean)mark2.equals(MARK2), (String)"The file doesn't have a valid OhmDB format (incorrect mark2)!", (Object[])new Object[0]);
    }

    private String readStr(ByteBuffer buf, int length) {
        byte[] strBuf = new byte[length];
        buf.get(strBuf);
        return new String(strBuf);
    }

    public synchronized void write(long key, Object value) throws IOException {
        FilestoreTransaction tx = this.transaction();
        tx.write(key, value);
        final AtomicBoolean done = new AtomicBoolean();
        tx.addListener(new TransactionListener(){

            public void onSuccess() {
                done.set(true);
            }

            public void onError(Exception e) {
                e.printStackTrace(System.err);
                done.set(true);
            }
        });
        tx.commit();
        U.waitFor((AtomicBoolean)done);
    }

    public synchronized void delete(long key) throws IOException {
        FilestoreTransaction tx = this.transaction();
        tx.delete(key);
        final AtomicBoolean done = new AtomicBoolean();
        tx.addListener(new TransactionListener(){

            public void onSuccess() {
                done.set(true);
            }

            public void onError(Exception e) {
                e.printStackTrace(System.err);
                done.set(true);
            }
        });
        tx.commit();
        U.waitFor((AtomicBoolean)done);
    }

    private void write(Long key, Object value, long txId, boolean delete) throws IOException, BufferFullException {
        Check.arg((txId >= 0L ? 1 : 0) != 0, (String)"Transaction ID must be >= 0!", (Object[])new Object[0]);
        int start = this.BUF.position();
        try {
            this.BUF.position(start + 32);
        }
        catch (IllegalArgumentException e) {
            this.BUF.position(start);
            throw new BufferFullException();
        }
        try {
            this.writeKeyValueToBUF(key, value, delete);
            this.completeZerosInBUF(start);
        }
        catch (BufferOverflowException e) {
            this.BUF.position(start);
            throw new BufferFullException();
        }
        int bytesN = this.BUF.position() - start;
        int size = this.sizeOf(bytesN);
        if (this.aggregatedSize + size > MAX_BLOCKS) {
            this.BUF.position(start);
            throw new BufferFullException();
        }
        this.aggregatedSize += size;
        KeyAndSize kas = new KeyAndSize();
        kas.key = key;
        kas.size = size;
        kas.bytesN = bytesN;
        kas.delete = delete;
        this.aggregatedKeys.add(kas);
    }

    private void writeTx(long txId) throws IOException {
        Set slots = this.zones.occupy(this.aggregatedSize);
        assert (slots.size() == this.aggregatedSize);
        this.BUF.position(0);
        Iterator<Long> it = slots.iterator();
        for (KeyAndSize ks : this.aggregatedKeys) {
            this.writeKS(it, ks.key, txId, ks.delete, ks.size, ks.bytesN);
        }
        assert (!it.hasNext());
    }

    private void writeKS(Iterator<Long> it, Long key, long txId, boolean delete, int size, int bytesN) throws IOException {
        PersistInfo info = this.infos.getInfo(key);
        HashSet<Long> theSlots = new HashSet<Long>();
        long version = info.nextVersion(theSlots);
        long address = it.next();
        int start = this.BUF.position();
        long second = size > 1 ? it.next() : -1L;
        this.putFirstInBUF(txId, delete, size, version, second);
        assert (this.BUF.position() == start);
        assert (bytesN >= 64);
        this.writeFirst(this.file, address);
        assert (this.BUF.position() == start + 64);
        theSlots.add(address);
        if (size > 1) {
            long prev = address;
            long addr = second;
            for (int p = 2; p <= size; ++p) {
                long next = p < size ? it.next() : prev;
                this.writeNext(this.file, addr, prev, next);
                theSlots.add(addr);
                prev = addr;
                addr = next;
            }
        }
        int total = this.BUF.position() - start;
        assert (total == bytesN);
        assert (this.sizeOf(total) == size);
        VersionInfo ver = info.getVersion(version - 1L);
        info.removeOldVersions();
        if (ver != null) {
            this.zones.releaseAll(ver.getSlots());
        }
    }

    private int sizeOf(int count) {
        if (count <= 64) {
            return 1;
        }
        int tailSize = count - 64;
        assert (tailSize > 0);
        int tailPartSize = 48;
        int tailN = tailSize / tailPartSize;
        if (tailSize % tailPartSize != 0) {
            ++tailN;
        }
        return 1 + tailN;
    }

    private void writeKeyValueToBUF(Long key, Object value, boolean delete) {
        this.BUF.putLong(key);
        if (!delete) {
            this.valueCodec.encode(this.BUF, value);
        }
    }

    private void completeZerosInBUF(int start) {
        int length = this.BUF.position() - start;
        assert (length > 0);
        if (length <= 64) {
            int zerosToPut = 64 - length;
            this.putZeros(zerosToPut);
            assert ((this.BUF.position() - start) % 64 == 0);
        } else {
            int tail = length - 64;
            int tailSize = 48;
            int aloneBytes = tail % tailSize;
            int zerosToPut = aloneBytes > 0 ? tailSize - aloneBytes : 0;
            this.putZeros(zerosToPut);
            int tail2 = this.BUF.position() - start - 64;
            assert (tail2 % tailSize == 0);
        }
        assert (this.BUF.position() - start - length < 64);
    }

    private void putZeros(int zerosToPut) {
        for (int i = 0; i < zerosToPut; ++i) {
            this.BUF.put((byte)0);
        }
    }

    private void putFirstInBUF(long txId, boolean delete, int size, long version, long next) throws IOException {
        int sizePosOrNeg = delete ? -size : size;
        int hash = this.hash(txId, sizePosOrNeg, version, next);
        int pos = this.BUF.position();
        this.BUF.putLong(txId);
        this.BUF.putLong(version);
        this.BUF.putInt(sizePosOrNeg);
        this.BUF.putLong(next);
        this.BUF.putInt(hash);
        this.BUF.position(pos);
    }

    private void writeFirst(RandomAccessFile fc, long address) throws IOException {
        assert (address >= 0L);
        fc.seek(1024L + address * 64L);
        this.writeNBytes(fc, this.BUF, 64);
    }

    private void writeFirstInformative(RandomAccessFile fc, long address) throws IOException {
        assert (address >= 0L);
        fc.seek(1024L + address * 64L);
        int pos = this.BUF.position();
        this.writeNBytes(fc, this.BUF, 64);
        long aa = this.BUF.getLong(pos);
        long bb = this.BUF.getLong(pos + 8);
        int cc = this.BUF.getInt(pos + 16);
        for (int i = 0; i < 32; ++i) {
            byte by = this.BUF.get(pos + i + 32);
            int ch = by > 0 ? (int)by : 63;
        }
    }

    private void writeNext(RandomAccessFile fc, long address, long prev, long next) throws IOException {
        assert (address >= 0L);
        assert (this.debug("===== WRITING next block at @" + address));
        assert (prev >= 0L);
        assert (next >= 0L);
        fc.seek(1024L + address * 64L);
        assert (this.BUF16.position() == 0);
        this.BUF16.putLong(this.negEncode(prev));
        this.BUF16.putLong(this.negEncode(next));
        assert (this.BUF16.position() == 16);
        this.BUF16.flip();
        this.write(fc, this.BUF16, 16);
        this.BUF16.clear();
        this.writeNBytes(fc, this.BUF, 48);
    }

    private void startWriting() throws IOException {
        long fileSize = this.file.length();
        if (fileSize == 0L) {
            this.createDb();
        } else {
            Check.state((fileSize >= 1024L ? 1 : 0) != 0, (String)"The OhmDB file header is too small!", (Object[])new Object[0]);
        }
    }

    private int hash(long txId, int size, long version, long next) {
        int ver1 = (int)(version >> 32);
        int ver2 = (int)version;
        int tx1 = (int)(txId >> 32);
        int tx2 = (int)txId;
        int nxt1 = (int)(next >> 32);
        int nxt2 = (int)next;
        int hash = tx1 * 3 + 1 ^ 91 + tx2 * 5 ^ 23 - ver1 * 7 ^ 97 + ver2 * 11 ^ 3 + nxt1 * 13 ^ nxt2 * 17 ^ size * 19;
        return hash;
    }

    private void write(RandomAccessFile fc, ByteBuffer out, int count) throws IOException {
        int real = 0;
        while (out.hasRemaining()) {
            real += fc.getChannel().write(out);
        }
        Check.state((count == real ? 1 : 0) != 0, (String)"The buffer wasn't correctly writen to the file! Expected: %s, wrote: %s bytes", (Object[])new Object[]{count, real});
    }

    private void writeNBytes(RandomAccessFile fc, ByteBuffer out, int count) throws IOException {
        int real = 0;
        out.limit(out.position() + count);
        while (out.hasRemaining()) {
            real += fc.getChannel().write(out);
        }
        Check.state((count == real ? 1 : 0) != 0, (String)"The buffer wasn't correctly writen to the file! Expected: %s, wrote: %s bytes", (Object[])new Object[]{count, real});
        out.limit(this.BUF.capacity());
    }

    private void transact(long txId, Map<Long, Object> values, Set<Long> deletedKeys) throws IOException, BufferFullException {
        for (Map.Entry<Long, Object> entry : values.entrySet()) {
            this.write(entry.getKey(), entry.getValue(), txId, false);
        }
        Iterator<Object> i$ = deletedKeys.iterator();
        while (i$.hasNext()) {
            long delKey = (Long)i$.next();
            this.write(delKey, null, txId, true);
        }
    }

    private void writeTxCounter(long txId) {
        this.TX_BUF.clear();
        this.TX_BUF.putLong(txId);
        this.TX_BUF.putLong(txId);
        this.TX_BUF.putLong(txId);
        this.TX_BUF.flip();
        try {
            RandomAccessFile txf = new RandomAccessFile(this.filename, "rw");
            long pos = this.firstTxCounter ? 9L : 33L;
            txf.seek(pos);
            this.write(txf, this.TX_BUF, 24);
            this.firstTxCounter = !this.firstTxCounter;
        }
        catch (IOException e) {
            throw Errors.rte((Throwable)e);
        }
    }

    public synchronized long getFileSize() {
        return new File(this.filename).length();
    }

    private void loadData(StoreLoader loader) {
        this.debug("====================================================================");
        assert (this.READ_BUF.capacity() % 64 == 0);
        try {
            RandomAccessFile fc = new RandomAccessFile(this.filename, "r");
            long fileSize = fc.length();
            this.loadHeader(fc);
            Check.state((fileSize < (long)this.READ_BUF.capacity() ? 1 : 0) != 0, (String)"Not enough read buffer!", (Object[])new Object[0]);
            FileChannel ch = fc.getChannel();
            while (ch.position() < fileSize) {
                int lastRead;
                long baseAddress = (ch.position() - 1024L) / 64L;
                this.READ_BUF.clear();
                int readN = 0;
                do {
                    if ((lastRead = fc.getChannel().read(this.READ_BUF)) <= 0) continue;
                    readN += lastRead;
                } while (lastRead > 0 && this.READ_BUF.hasRemaining());
                assert (readN % 64 == 0);
                this.READ_BUF.flip();
                if (readN <= 0) continue;
                this.READ_BUF.rewind();
                this.loadBulk(loader, this.READ_BUF, baseAddress, readN);
            }
            for (PersistInfo info : this.infos.entries()) {
                VersionInfo latest = info.getLatestVersion();
                this.zones.occupiedAll(latest.getSlots());
                info.removeOldVersions();
            }
        }
        catch (IOException e) {
            throw Errors.rte((Throwable)e);
        }
        this.debug("===== Total blocks loaded: " + this.totalBlocks + " (" + this.errorBlocks + " of them corrupted)");
        this.debug("====================================================================");
        if (this.errorBlocks > 0) {
            throw Errors.rte((String)("Total " + this.errorBlocks + " blocks were corrupted!"), (Object[])new Object[0]);
        }
    }

    private void loadBulk(StoreLoader loader, ByteBuffer buf, long baseAddress, int readN) {
        assert (buf.hasRemaining());
        assert (this.debug("=== LOAD @" + buf.position() + " (base address=" + baseAddress + ")"));
        int blocksN = readN / 64;
        int loadedN = 0;
        for (int i = 0; i < blocksN; ++i) {
            boolean ok = this.loadBlock(loader, buf, baseAddress, i);
            if (!ok) continue;
            ++loadedN;
        }
        this.debug("TOTAL LOADED BLOCKS = " + loadedN);
    }

    private boolean loadBlock(StoreLoader loader, ByteBuffer buf, long base, int offset) {
        long address = base + (long)offset;
        buf.position(offset * 64);
        long txOrder = buf.getLong();
        long version = buf.getLong();
        if (txOrder < 0L) {
            return false;
        }
        ++this.totalBlocks;
        int size = buf.getInt();
        long next = buf.getLong();
        int hash = buf.getInt();
        assert (this.debug("tx=" + txOrder + " ver=" + version + " size=" + size + " CRC=" + hash));
        boolean success = true;
        int hashv = this.hash(txOrder, size, version, next);
        if (txOrder == 0L && size == 0 && hash == 0 && version == 0L) {
            return false;
        }
        if (hash == hashv) {
            if (txOrder != -1L) {
                success &= this.check(txOrder >= 0L, "Transaction order must be >= 0!");
                success &= this.check(version > 0L, "Version must be greater than 0!");
                if (success &= this.check(size != 0, "Size must not be 0!")) {
                    try {
                        this.loadFirst(loader, buf, base, offset, version, size, next);
                    }
                    catch (Throwable e) {
                        throw Errors.rte((String)"Cannot read data block!", (Throwable)e);
                    }
                }
            } else {
                success &= this.check(version == 0L, "Version must be 0!");
                success &= this.check(size != 0, "Size must not be 0!");
            }
        } else {
            success = false;
            ++this.errorBlocks;
            this.error("Corrupted block detected at address " + address + this.hex(address) + " (" + "tx=" + txOrder + " ver=" + version + " size=" + size + " hash=" + hash + ")");
        }
        return success;
    }

    private String hex(long address) {
        return " [mem " + Long.toHexString(1024L + address * 64L) + "] ";
    }

    private int loadNext(ByteBuffer buf, Set<Long> slots, long base, long commingFrom, long offset, int arrN) {
        boolean hasMore;
        do {
            long address = base + offset;
            slots.add(address);
            buf.position((int)offset * 64);
            long aa = this.negDecode(buf.getLong());
            long bb = this.negDecode(buf.getLong());
            hasMore = aa != bb;
            long prev = aa - base;
            if (!this.check(prev == commingFrom, "Broken block chain!")) {
                return 0;
            }
            buf.get(this.READ_ITEM_ARR, arrN, 48);
            arrN += 48;
            commingFrom = offset;
            offset = bb - base;
        } while (hasMore);
        return arrN;
    }

    private void loadFirst(StoreLoader loader, ByteBuffer buf, long base, int offset, long version, int size, long next) {
        PersistInfo info;
        boolean delete;
        long address = base + (long)offset;
        boolean bl = delete = size < 0;
        if (delete) {
            size = -size;
        }
        Set slots = U.set((Object[])new Long[]{address});
        buf.position(offset * 64 + 32);
        buf.get(this.READ_ITEM_ARR, 0, 32);
        int arrN = 32;
        if (next >= 0L) {
            arrN = this.loadNext(buf, slots, base, offset, next - base, arrN);
        }
        this.READ_ITEM_BUF.position(0);
        this.READ_ITEM_BUF.limit(arrN);
        Object value = null;
        Long key = this.READ_ITEM_BUF.getLong();
        assert (this.debug("DECODED Long: " + key));
        if (!delete) {
            value = this.valueCodec.decode(this.READ_ITEM_BUF);
        }
        if ((info = this.infos.getInfo(key)).loadVersion(version, slots)) {
            if (delete) {
                this.nice("DELETE key=" + key);
                loader.delete(key);
            } else {
                this.nice("SET key=" + key + " : val=" + value);
                loader.set(key, value);
            }
        }
    }

    private boolean skippedZeros(byte[] skipped) {
        for (int i = 0; i < skipped.length; ++i) {
            if (skipped[i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean check(boolean expectedCondition, String errorMsg) {
        if (!expectedCondition) {
            this.error(errorMsg);
        }
        return expectedCondition;
    }

    public FilestoreTransaction transaction() {
        this.checkActive();
        return new FilestoreTransaction(this, this.db());
    }

    public Map<DbStats, Object> getStats() {
        return this.dbstats;
    }

    public synchronized void clear() {
        throw Errors.notReady();
    }

    private boolean debug(String msg) {
        return true;
    }

    private void nice(String msg) {
    }

    private void error(String msg) {
        System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.err.println("!!! OhmDB ERROR: " + msg);
        System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    private long negEncode(long n) {
        assert (n >= 0L);
        return Long.MIN_VALUE + n;
    }

    private long negDecode(long n) {
        if (n >= 0L) {
            throw Errors.rte((String)("neg:" + n), (Object[])new Object[0]);
        }
        assert (n < 0L);
        return n - Long.MIN_VALUE;
    }

    public void commit(DatastoreTransaction tx) {
        while (!this.txs.offer(tx)) {
            U.sleep((long)5L);
        }
    }

    public void rollback(DatastoreTransaction tx) {
        this.releaseTx(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transact(long txId, DatastoreTransaction tx) throws BufferFullException {
        try {
            this.transact(txId, tx.changed(), tx.deleted());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void run() {
        try {
            ArrayList<DatastoreTransaction> currentTxs = new ArrayList<DatastoreTransaction>(20000);
            while (this.dbExists() && this.running.get() || !this.txs.isEmpty()) {
                DatastoreTransaction tx;
                boolean transacted = true;
                while (this.txs.isEmpty() && this.running.get()) {
                    U.sleep((long)10L);
                }
                this.BUF.rewind();
                long txId = this.txCounter.incrementAndGet();
                int n = 0;
                this.aggregatedSize = 0;
                this.aggregatedKeys.clear();
                currentTxs.clear();
                while (transacted && (tx = this.txs.peek()) != null) {
                    block12: {
                        try {
                            transacted = tx.isReadOnly() ? true : this.transact(txId, tx);
                        }
                        catch (BufferFullException e) {
                            transacted = false;
                            if (!currentTxs.isEmpty()) break block12;
                            throw Errors.rte((String)"The transaction is too big!", (Object[])new Object[0]);
                        }
                    }
                    if (!transacted) continue;
                    ++n;
                    DatastoreTransaction tx2 = this.txs.poll();
                    assert (tx == tx2);
                    currentTxs.add(tx);
                }
                this.debug("TRANSACTING N=" + n);
                if (this.aggregatedSize > 0) {
                    this.writeTx(txId);
                    this.writeTxCounter(txId);
                    this.file.getChannel().force(false);
                }
                for (DatastoreTransaction txx : currentTxs) {
                    txx.success();
                    this.releaseTx(txx);
                }
            }
        }
        catch (Throwable e) {
            if (this.running.get()) {
                Db db = (Db)this.dbRef.get();
                if (db != null) {
                    ((OhmDBImpl)db).failure(e);
                }
                throw Errors.rte((Throwable)e);
            }
            e.printStackTrace();
        }
        this.print("File store thread finished.");
        this.finished.set(true);
    }

    private void print(String msg) {
    }

    private boolean dbExists() {
        return this.dbRef == null || this.dbRef.get() != null;
    }

    @Override
    public void stop() {
        super.stop();
        this.thread.interrupt();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        while (!this.finished.get()) {
            U.sleep((long)10L);
        }
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw Errors.rte((String)"Couldn't close database file!", (Throwable)e);
        }
    }

    private void releaseTx(DatastoreTransaction tx) {
        tx.done();
    }
}

