/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.filestore;

import com.ohmdb.abstracts.DataSource;
import com.ohmdb.abstracts.DataStore;
import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.api.TransactionListener;
import com.ohmdb.filestore.TxState;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilestoreTransaction
implements DatastoreTransaction {
    final DataStore store;
    final DataSource source;
    final Set<Long> changed = new HashSet<Long>(1);
    final Map<Long, Object> values = new HashMap<Long, Object>(1);
    final Set<Long> deleted = new HashSet<Long>(1);
    final List<TransactionListener> listeners = new ArrayList<TransactionListener>(1);
    private TxState state = TxState.INITIAL;

    FilestoreTransaction(DataStore store, DataSource source) {
        Check.notNull((Object)store, (String)"store");
        Check.notNull((Object)source, (String)"source");
        this.store = store;
        this.source = source;
    }

    public synchronized void changed(long key) {
        if (this.state != TxState.INITIAL && this.state != TxState.RESET) {
            throw Errors.rte((String)"Cannot write to freezed transaction!", (Object[])new Object[0]);
        }
        this.changed.add(key);
    }

    public synchronized void write(long key, Object value) {
        if (this.state != TxState.INITIAL && this.state != TxState.RESET) {
            throw Errors.rte((String)"Cannot write to freezed transaction!", (Object[])new Object[0]);
        }
        this.values.put(key, value);
    }

    public synchronized void delete(long key) {
        if (this.state != TxState.INITIAL && this.state != TxState.RESET) {
            throw Errors.rte((String)"Cannot write to freezed transaction!", (Object[])new Object[0]);
        }
        this.values.remove(key);
        this.changed.remove(key);
        this.deleted.add(key);
    }

    public synchronized void commit() {
        this.state = TxState.COMMITING;
        if (!this.isReadOnly() || !this.listeners.isEmpty()) {
            for (long key : this.changed) {
                this.values.put(key, this.source.read(key));
            }
            this.changed.clear();
            this.store.commit((DatastoreTransaction)this);
        }
    }

    public synchronized void rollback() {
        this.state = TxState.ROLLING_BACK;
        this.store.rollback((DatastoreTransaction)this);
    }

    public synchronized void addListener(TransactionListener listener) {
        Check.arg((!this.listeners.contains(listener) ? 1 : 0) != 0, (String)"Listener already registered for this transaction!", (Object[])new Object[0]);
        this.listeners.add(listener);
    }

    public synchronized void success() {
        for (TransactionListener listener : this.listeners) {
            listener.onSuccess();
        }
    }

    public synchronized boolean isReadOnly() {
        return this.changed.isEmpty() && this.values.isEmpty() && this.deleted.isEmpty();
    }

    public synchronized void done() {
        this.state = TxState.DONE;
    }

    public Map<Long, Object> changed() {
        return this.values;
    }

    public Set<Long> deleted() {
        return this.deleted;
    }
}

