/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.filestore;

import com.ohmdb.filestore.VersionInfo;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class PersistInfo {
    private final NavigableMap<Long, VersionInfo> versions = new TreeMap<Long, VersionInfo>();
    private long version = 0L;

    public long nextVersion(Set<Long> slots) {
        long newVersion = ++this.version;
        this.versions.put(newVersion, new VersionInfo(slots));
        return newVersion;
    }

    public VersionInfo getVersion(long version) {
        return (VersionInfo)this.versions.get(version);
    }

    public boolean loadVersion(long loadedVersion, Set<Long> slots) {
        this.versions.put(loadedVersion, new VersionInfo(slots));
        if (this.version < loadedVersion) {
            this.version = loadedVersion;
            return true;
        }
        return false;
    }

    public VersionInfo getLatestVersion() {
        return this.versions.lastEntry().getValue();
    }

    public void removeOldVersions() {
    }
}

