/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.filestore;

import com.ohmdb.abstracts.Zones;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import java.util.BitSet;
import java.util.Set;
import java.util.TreeSet;

public class ZonesImpl
implements Zones {
    private final BitSet bs = new BitSet(256);
    private int cardinality;

    public synchronized Set<Long> occupy(int num) {
        Check.arg((num > 0 ? 1 : 0) != 0, (String)"Ocupation size must be greater than 0!", (Object[])new Object[0]);
        return this.hasFree(num) ? this.recycle(num) : this.expand(num);
    }

    private boolean hasFree(int num) {
        return this.unused() >= num;
    }

    private Set<Long> expand(int num) {
        TreeSet<Long> positions = new TreeSet<Long>();
        for (int pos = this.bs.length(); pos < this.bs.length() + num; ++pos) {
            positions.add(Long.valueOf(pos));
        }
        this.bs.set(this.bs.length(), this.bs.length() + num);
        this.cardinality += num;
        assert (this.cardinality == this.bs.cardinality());
        return positions;
    }

    private Set<Long> recycle(int num) {
        TreeSet<Long> positions = new TreeSet<Long>();
        int n = 0;
        int pos = this.bs.nextClearBit(0);
        while (pos >= 0) {
            positions.add(Long.valueOf(pos));
            this.bs.set(pos);
            if (++n == num) {
                this.cardinality += num;
                assert (this.cardinality == this.bs.cardinality());
                return positions;
            }
            pos = this.bs.nextClearBit(pos + 1);
        }
        throw Errors.notExpected();
    }

    private int unused() {
        return this.bs.size() - this.cardinality();
    }

    public synchronized void occupied(long position) {
        assert (!this.bs.get((int)position));
        this.bs.set((int)position);
        ++this.cardinality;
        assert (this.cardinality == this.bs.cardinality());
    }

    public synchronized void release(long position) {
        assert (this.bs.get((int)position));
        this.bs.clear((int)position);
        --this.cardinality;
        assert (this.cardinality == this.bs.cardinality());
    }

    public synchronized void releaseAll(long ... positions) {
        for (long position : positions) {
            this.release(position);
        }
    }

    public synchronized void releaseAll(Set<Long> positions) {
        for (long position : positions) {
            this.release(position);
        }
    }

    public synchronized void occupiedAll(Set<Long> positions) {
        for (long position : positions) {
            this.occupied(position);
        }
    }

    public synchronized String toString() {
        return "Zones cardinality: " + this.cardinality;
    }

    public synchronized int cardinality() {
        assert (this.cardinality == this.bs.cardinality());
        return this.cardinality;
    }
}

