/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.abstracts.IdAddress;
import com.ohmdb.abstracts.IdColl;
import com.ohmdb.impl.OhmDBStats;
import java.util.HashMap;
import java.util.Map;

public class MapBackedIdColl
implements IdColl {
    private final Map<Long, IdAddress> addresses = new HashMap<Long, IdAddress>();
    private long counter;
    private final OhmDBStats stats;

    public MapBackedIdColl(OhmDBStats stats) {
        this.stats = stats;
    }

    public synchronized boolean has(long id) {
        return this.addresses.containsKey(id);
    }

    public synchronized IdAddress get(long id) {
        return this.addresses.get(id);
    }

    public synchronized void set(long id, IdAddress addr) {
        this.addresses.put(id, addr);
    }

    public synchronized void delete(long id) {
        this.addresses.remove(id);
    }

    public synchronized void clear() {
        this.addresses.clear();
    }

    public synchronized boolean isValid(long id) {
        return id >= 0L && id < this.counter && this.has(id);
    }

    public synchronized long newId() {
        return this.counter++;
    }

    public synchronized void registerId(long id) {
        this.counter = Math.max(this.counter, id + 1L);
    }

    public synchronized void cancelId(long id) {
        if (id == this.counter - 1L) {
            --this.counter;
        }
    }
}

