/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.TableInternals;
import com.ohmdb.abstracts.DataImporter;
import com.ohmdb.abstracts.DataSource;
import com.ohmdb.abstracts.DataStore;
import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.abstracts.IdAddress;
import com.ohmdb.abstracts.IdColl;
import com.ohmdb.abstracts.LoadedData;
import com.ohmdb.abstracts.LockManager;
import com.ohmdb.abstracts.RWRelation;
import com.ohmdb.abstracts.RelationInternals;
import com.ohmdb.api.Db;
import com.ohmdb.api.Ids;
import com.ohmdb.api.Op;
import com.ohmdb.api.SearchCriteria;
import com.ohmdb.api.Table;
import com.ohmdb.api.Transaction;
import com.ohmdb.api.Trigger;
import com.ohmdb.api.TriggerAction;
import com.ohmdb.api.TriggerCreator;
import com.ohmdb.bean.PropertyInfo;
import com.ohmdb.codec.ByteArrCodec;
import com.ohmdb.codec.StoreCodec;
import com.ohmdb.dsl.OhmDbDSL;
import com.ohmdb.dsl.join.LinkMatcher;
import com.ohmdb.dsl.rel.SearchCriteriaImpl;
import com.ohmdb.exception.InvalidIdException;
import com.ohmdb.filestore.DataLoader;
import com.ohmdb.filestore.FileStore;
import com.ohmdb.filestore.NoDataStore;
import com.ohmdb.impl.AnyIds;
import com.ohmdb.impl.IdsImpl;
import com.ohmdb.impl.LockManagerImpl;
import com.ohmdb.impl.MapBackedIdColl;
import com.ohmdb.impl.OhmDBStats;
import com.ohmdb.impl.ShutdownThread;
import com.ohmdb.impl.TableImpl;
import com.ohmdb.impl.TriggerCreatorImpl;
import com.ohmdb.impl.Triggering;
import com.ohmdb.join.DefaultLinkMatcher;
import com.ohmdb.relation.RelationImpl;
import com.ohmdb.transaction.TransactionImpl;
import com.ohmdb.transaction.TransactorImpl;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OhmDBImpl
extends OhmDbDSL
implements Db,
DataSource,
DataImporter {
    private final StoreCodec<byte[]> VALUE_CODEC = new ByteArrCodec();
    private final OhmDBStats stats = new OhmDBStats();
    private final IdColl ids = new MapBackedIdColl(this.stats);
    private final Map<Class<?>, Table<?>> tables = new HashMap();
    private final Map<String, RWRelation> relations = new HashMap<String, RWRelation>();
    private final List<Triggering<?>> triggers = new ArrayList();
    private final DataStore store;
    private final LockManager lockManager = new LockManagerImpl(this.stats);
    private final TransactorImpl transactor = new TransactorImpl(this, this.lockManager, this.stats);
    private final WeakReference<Db> dbRef;
    private boolean isDown = false;
    private final ByteBuffer SER_HELPER = ByteBuffer.allocateDirect(0x100000);
    private Throwable error;

    public OhmDBImpl(String filename) {
        super((LinkMatcher)new DefaultLinkMatcher());
        this.dbRef = new WeakReference<OhmDBImpl>(this);
        DataLoader loader = new DataLoader();
        this.store = new FileStore(filename, loader, this.VALUE_CODEC, this.stats, false, this.dbRef);
        LoadedData data = loader.getData();
        data.fillData((DataImporter)this);
        this.addShutdownHook();
    }

    public OhmDBImpl() {
        super((LinkMatcher)new DefaultLinkMatcher());
        this.dbRef = new WeakReference<OhmDBImpl>(this);
        this.store = new NoDataStore(this);
        this.addShutdownHook();
    }

    public Transaction startTransaction() {
        DatastoreTransaction tx = this.store.transaction();
        TransactionImpl transaction = new TransactionImpl(this.transactor, tx);
        transaction.begin();
        return transaction;
    }

    public synchronized <T> Table<T> table(Class<T> clazz) {
        Table<?> table = this.tables.get(clazz);
        if (table == null) {
            table = new TableImpl<T>(this, clazz, this.store, this.ids, this.transactor, this.stats, this.lockManager);
            this.tables.put(clazz, table);
            for (Triggering<?> triggering : this.triggers) {
                this.registerTriggers(triggering, table);
            }
        }
        return table;
    }

    public synchronized <T> Table<T> table(String fullClassname) {
        try {
            Class<?> clazz = Class.forName(fullClassname);
            return this.table(clazz);
        }
        catch (ClassNotFoundException e) {
            throw Errors.rte((Throwable)e);
        }
    }

    public synchronized void rollback() {
        TableInternals internal;
        for (Table<?> table : this.tables.values()) {
            internal = (TableInternals)table;
            internal.rollback();
        }
        for (RWRelation rel : this.relations.values()) {
            internal = (RelationInternals)rel;
            internal.rollback();
        }
    }

    public synchronized void commit() {
        TableInternals internal;
        for (Table<?> table : this.tables.values()) {
            internal = (TableInternals)table;
            internal.commit();
        }
        for (RWRelation rel : this.relations.values()) {
            internal = (RelationInternals)rel;
            internal.commit();
        }
    }

    public synchronized RWRelation relation(Table<?> from, String name, Table<?> to) {
        Object rel = this.relations.get(name);
        if (rel == null) {
            rel = new RelationImpl(from, name, to, this.store, this.ids, this.transactor, this.lockManager, this.stats);
            this.relations.put(name, (RWRelation)rel);
        }
        return rel;
    }

    protected synchronized <FROM, TO> RWRelation relation(Table<FROM> from, String name, Table<TO> to, boolean symmetric, boolean manyFroms, boolean manyTos) {
        Object rel = this.relations.get(name);
        if (rel == null) {
            rel = new RelationImpl<FROM, TO>(from, name, to, this.store, this.ids, this.transactor, this.lockManager, this.stats, symmetric, manyFroms, manyTos);
            this.relations.put(name, (RWRelation)rel);
        } else {
            rel.kind(symmetric, manyFroms, manyTos);
        }
        return rel;
    }

    public void delete(long id) {
        IdAddress address = this.address(id);
        address.table.delete(id);
    }

    private IdAddress address(long id) {
        IdAddress address = this.ids.get(id);
        if (address == null) {
            throw new InvalidIdException(id);
        }
        return address;
    }

    public void update(Object entity) {
        long id = U.getId((Object)entity);
        IdAddress address = this.address(id);
        ((TableInternals)address.table).updateObj(entity);
    }

    public <T> TriggerCreator<T> before(Class<T> type) {
        return new TriggerCreatorImpl<T>(this, type, true, new TriggerAction[0]);
    }

    public <T> TriggerCreator<T> after(Class<T> type) {
        return new TriggerCreatorImpl<T>(this, type, false, new TriggerAction[0]);
    }

    public <T> void trigger(Class<T> type, TriggerAction action, Trigger<T> trigger) {
        Triggering<T> triggering = new Triggering<T>(type, action, trigger);
        this.triggers.add(triggering);
        for (Table<?> table : this.tables.values()) {
            this.registerTriggers(triggering, table);
        }
    }

    private <T> void registerTriggers(Triggering<T> triggering, Table<?> table) {
        TableInternals tbl = (TableInternals)table;
        if (triggering.type.isAssignableFrom(tbl.getClazz())) {
            tbl.addTrigger(triggering.action, triggering.trigger);
        }
    }

    public RWRelation relation(String name) {
        return this.relation(null, name, null);
    }

    public SearchCriteria crit(String columnName, Op op, Object value) {
        return SearchCriteriaImpl.single((String)columnName, (Op)op, (Object)value);
    }

    public <T> Ids<T> ids(long ... ids) {
        return new IdsImpl(ids);
    }

    public <T> Ids<T> all(long ... ids) {
        return new AnyIds(ids);
    }

    public synchronized void stop() {
        this.store.stop();
    }

    public synchronized void shutdown() {
        if (!this.isDown) {
            System.out.println("Shutting down database...");
            this.store.shutdown();
            this.isDown = true;
            System.out.println("Database stopped.");
        }
        if (this.error != null) {
            throw Errors.rte((String)"Persistence error detected!", (Throwable)this.error);
        }
    }

    public LinkMatcher getLinkMatcher() {
        assert (this.linkMatcher != null);
        return this.linkMatcher;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this.dbRef));
    }

    public synchronized byte[] exportRecord(long id) {
        this.SER_HELPER.clear();
        this.exportColumns(id);
        this.exportRelations(id);
        this.SER_HELPER.flip();
        byte[] bytes = new byte[this.SER_HELPER.limit()];
        this.SER_HELPER.get(bytes);
        return bytes;
    }

    private void exportColumns(long id) {
        IdAddress address = this.ids.get(id);
        boolean exportTableData = address != null;
        U.encode((Object)exportTableData, (ByteBuffer)this.SER_HELPER);
        if (exportTableData) {
            TableInternals table = (TableInternals)address.table;
            PropertyInfo[] props = table.props();
            U.encode((Object)table.getClazz().getCanonicalName(), (ByteBuffer)this.SER_HELPER);
            U.encode((Object)props.length, (ByteBuffer)this.SER_HELPER);
            for (PropertyInfo prop : props) {
                String colName = prop.getName();
                Object colVal = prop.getColumn().get(address.row);
                U.encode((Object)colName, (ByteBuffer)this.SER_HELPER);
                U.encode((Object)colVal, (ByteBuffer)this.SER_HELPER);
            }
        }
    }

    private void exportRelations(long id) {
        U.encode((Object)this.relations.size(), (ByteBuffer)this.SER_HELPER);
        for (Map.Entry<String, RWRelation> rel : this.relations.entrySet()) {
            U.encode((Object)rel.getKey(), (ByteBuffer)this.SER_HELPER);
            long[] links = rel.getValue().linksFrom(id).toArray();
            U.encode((Object)links.length, (ByteBuffer)this.SER_HELPER);
            for (long link : links) {
                U.encode((Object)link, (ByteBuffer)this.SER_HELPER);
            }
        }
    }

    public synchronized void importRecord(long id, byte[] bytes) {
        this.SER_HELPER.clear();
        this.SER_HELPER.put(bytes);
        this.SER_HELPER.flip();
        boolean importTableData = (Boolean)this.decode();
        if (importTableData) {
            this.importColumns(id);
        }
        this.importRelations(id);
    }

    private void importColumns(long id) {
        String fullName = (String)this.decode();
        int colN = (Integer)this.decode();
        Table table = this.table(fullName);
        TableInternals table2 = (TableInternals)table;
        for (int i = 0; i < colN; ++i) {
            String colName = (String)this.decode();
            Object colVal = this.decode();
            table2.fill(id, colName, colVal);
        }
    }

    private void importRelations(long id) {
        int relN = (Integer)this.decode();
        for (int i = 0; i < relN; ++i) {
            String relName = (String)this.decode();
            RelationInternals rel = (RelationInternals)this.relation(relName);
            int linksN = (Integer)this.decode();
            for (int j = 0; j < linksN; ++j) {
                long linkTo = (Long)this.decode();
                rel.fill(id, linkTo);
            }
        }
    }

    private Object decode() {
        Object val = U.decode((ByteBuffer)this.SER_HELPER);
        return val;
    }

    public Object read(long id) {
        return this.exportRecord(id);
    }

    public synchronized void deleteRelsInTx(long id, DatastoreTransaction tx) {
        for (RWRelation rel : this.relations.values()) {
            RelationInternals rel2 = (RelationInternals)rel;
            rel2.deleteFromInTx(id, tx);
            rel2.deleteToInTx(id, tx);
        }
    }

    public synchronized void failure(Throwable e) {
        this.error = e;
    }

    public long insert(Object entity) {
        Table<?> tbl = this.table(entity.getClass());
        return tbl.insert(entity);
    }

    public <T> T get(long id) {
        return (T)this.address((long)id).table.get(id);
    }
}

