/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.abstracts.Column;
import com.ohmdb.util.Errors;
import java.lang.reflect.Method;
import java.util.List;

public class PropertyColumn
implements Column {
    private final List<?> records;
    private final Method getter;
    private final Method setter;

    public PropertyColumn(Method getter, Method setter, List<?> records) {
        this.getter = getter;
        this.setter = setter;
        this.records = records;
    }

    public void set(int row, Object value) {
        Object instance = this.row(row);
        try {
            this.setter.invoke(instance, value);
        }
        catch (Exception e) {
            throw Errors.rte((String)"Cannot get field value!", (Throwable)e);
        }
    }

    public Object get(int row) {
        Object instance = this.row(row);
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw Errors.rte((String)"Cannot get field value!", (Throwable)e);
        }
    }

    public Object delete(int row) {
        Object instance = this.row(row);
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw Errors.rte((String)"Cannot get field value!", (Throwable)e);
        }
    }

    public void clear() {
    }

    private Object row(int row) {
        return this.records.get(row);
    }
}

