/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.TableInternals;
import com.ohmdb.abstracts.Any;
import com.ohmdb.abstracts.Column;
import com.ohmdb.abstracts.ComplexIndex;
import com.ohmdb.abstracts.DataStore;
import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.abstracts.DbInsider;
import com.ohmdb.abstracts.IdAddress;
import com.ohmdb.abstracts.IdColl;
import com.ohmdb.abstracts.Index;
import com.ohmdb.abstracts.JokerCreator;
import com.ohmdb.abstracts.LockManager;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.abstracts.Prop;
import com.ohmdb.api.CustomIndex;
import com.ohmdb.api.Ids;
import com.ohmdb.api.Mapper;
import com.ohmdb.api.Op;
import com.ohmdb.api.Parameter;
import com.ohmdb.api.SearchCriteria;
import com.ohmdb.api.SearchCriteriaKind;
import com.ohmdb.api.SearchCriterion;
import com.ohmdb.api.Table;
import com.ohmdb.api.Transaction;
import com.ohmdb.api.Transformer;
import com.ohmdb.api.Trigger;
import com.ohmdb.api.TriggerAction;
import com.ohmdb.api.Visitor;
import com.ohmdb.bean.BeanInfo;
import com.ohmdb.bean.BeanIntrospector;
import com.ohmdb.bean.PropertyInfo;
import com.ohmdb.dsl.TableDSL;
import com.ohmdb.dsl.rel.SearchCriteriaImpl;
import com.ohmdb.exception.InvalidColumnException;
import com.ohmdb.exception.InvalidIdException;
import com.ohmdb.impl.AnySearch;
import com.ohmdb.impl.ComplexIndexImpl;
import com.ohmdb.impl.FieldColumn;
import com.ohmdb.impl.IgnorantInsider;
import com.ohmdb.impl.IndexerImpl;
import com.ohmdb.impl.OhmDBImpl;
import com.ohmdb.impl.OhmDBStats;
import com.ohmdb.impl.PropertyColumn;
import com.ohmdb.impl.RecordsImpl;
import com.ohmdb.impl.TableChange;
import com.ohmdb.impl.TreeIndex;
import com.ohmdb.numbers.Nums;
import com.ohmdb.transaction.TransactionInternals;
import com.ohmdb.transaction.Transactor;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TableImpl<E>
extends TableDSL<E>
implements Table<E>,
TableInternals<E> {
    private long deletedCount;
    private int size;
    private int rows;
    private final SortedSet<Long> ids = new TreeSet<Long>();
    private final Queue<Integer> deleted = new LinkedList<Integer>();
    private final List<Integer> currentlyDeleted = new LinkedList<Integer>();
    private final BeanIntrospector introspector = new BeanIntrospector();
    private final OhmDBImpl db;
    private final Class<E> clazz;
    private final BeanInfo info;
    private final PropertyInfo idtor;
    private final PropertyInfo[] props;
    private final DataStore store;
    private final IdColl idColl;
    private final Transactor transactor;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<TableChange> changelog = new ArrayList<TableChange>(10000);
    private final OhmDBStats stats;
    private final LockManager locker;
    private DbInsider insider = new IgnorantInsider();
    private final Constructor<E> constr;
    private final E queryHelper;
    private final List<E> records = new ArrayList(10000);
    private ComplexIndex<E>[] allComplexIndices = new ComplexIndex[0];
    private final ComplexIndex<E>[] tmpIndices = new ComplexIndex[1000];
    private Trigger<E>[] beforeUpdate = new Trigger[0];
    private Trigger<E>[] afterUpdate = new Trigger[0];
    private Trigger<E>[] beforeInsert = new Trigger[0];
    private Trigger<E>[] beforeRead = new Trigger[0];
    private Trigger<E>[] afterInsert = new Trigger[0];
    private Trigger<E>[] beforeDelete = new Trigger[0];
    private Trigger<E>[] afterDelete = new Trigger[0];
    private Trigger<E>[] afterRead = new Trigger[0];

    public TableImpl(OhmDBImpl db, Class<E> clazz, DataStore store, IdColl ids, Transactor transactor, OhmDBStats stats, LockManager lockManager) {
        this.db = db;
        this.idColl = ids;
        this.transactor = transactor;
        this.stats = stats;
        this.locker = lockManager;
        this.info = this.introspector.describe(clazz);
        this.clazz = clazz;
        this.store = store;
        this.size = 0;
        this.rows = 0;
        this.props = this.info.getProps();
        this.idtor = this.info.getIdtor();
        this.constr = this.findConstructor();
        this.queryHelper = this.newEntity();
        this.init();
    }

    private void init() {
        for (PropertyInfo prop : this.props) {
            prop.setColumn(this.createColumn(prop));
        }
        for (PropertyInfo prop : this.props) {
            this.jokerator.encode(this.queryHelper, (Prop)prop);
        }
    }

    private Column createColumn(PropertyInfo prop) {
        Field field = prop.getField();
        Object column = field != null ? new FieldColumn(field, this.records) : new PropertyColumn(prop.getGetter(), prop.getSetter(), this.records);
        return column;
    }

    private Constructor<E> findConstructor() {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = this.clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            Constructor<?> cons = constructor;
            cons.setAccessible(true);
            return cons;
        }
        throw Errors.rte((String)("Couldn't find 0-params constructor for class: " + this.clazz), (Object[])new Object[0]);
    }

    private void doTriggers(Trigger<E>[] triggers, TriggerAction action, long id, E old, E pre) {
        for (int i = 0; i < triggers.length; ++i) {
            triggers[i].process(action, id, old, pre);
        }
    }

    private PropertyInfo colInfo(String columnName) {
        return this.info.getProperties().get(columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(long id, String col) {
        try {
            this.locker.globalReadLock();
            this.checkId(id);
            this.insider.reading(this.clazz, id, col);
            Object value = this.readCell(id, col);
            this.insider.read(this.clazz, id, col, value);
            Object object = value;
            return object;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            long[] allIds;
            this.locker.globalWriteLock();
            DatastoreTransaction tx = this.getTransaction();
            for (long id : allIds = this.ids()) {
                this.deleteInTx(tx, id);
            }
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private E get_(long id) {
        E entity = this.newEntity();
        this.get_(id, entity);
        return entity;
    }

    private void get_(long id, E entity) {
        for (PropertyInfo prop : this.props) {
            Column column = prop.getColumn();
            Object value = column.get(this.row(id));
            prop.set(entity, value);
        }
        this.setId(entity, id);
    }

    private void get_(long id, E entity1, E entity2) {
        for (PropertyInfo prop : this.props) {
            Column column = prop.getColumn();
            Object value = column.get(this.row(id));
            prop.set(entity1, value);
            prop.set(entity2, value);
        }
        this.setId(entity1, id);
        this.setId(entity2, id);
    }

    private void get_(long id, E entity1, E entity2, E entity3) {
        for (PropertyInfo prop : this.props) {
            Column column = prop.getColumn();
            Object value = column.get(this.row(id));
            prop.set(entity1, value);
            prop.set(entity2, value);
            prop.set(entity3, value);
        }
        this.setId(entity1, id);
        this.setId(entity2, id);
        this.setId(entity3, id);
    }

    private void setId(E entity, long id) {
        if (this.idtor != null) {
            this.idtor.set(entity, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long id) {
        try {
            this.locker.globalReadLock();
            this.checkId(id);
            this.insider.getting(this.clazz, id);
            E entity = this.newEntity();
            this.doTriggers(this.beforeRead, TriggerAction.BEFORE_READ, id, null, entity);
            this.get_(id, entity);
            this.doTriggers(this.afterRead, TriggerAction.AFTER_READ, id, null, entity);
            this.insider.got(this.clazz, id, entity);
            E e = entity;
            return e;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(long id, E entity) {
        try {
            this.locker.globalReadLock();
            this.checkId(id);
            this.insider.getting(this.clazz, id);
            this.doTriggers(this.beforeRead, TriggerAction.BEFORE_READ, id, null, entity);
            this.get_(id, entity);
            this.doTriggers(this.afterRead, TriggerAction.AFTER_READ, id, null, entity);
            this.insider.got(this.clazz, id, entity);
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    private E newEntity() {
        try {
            return this.constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Errors.rte((Throwable)e);
        }
    }

    private int row(long id) {
        IdAddress addr = this.idColl.get(id);
        Check.notNull((Object)addr, (String)("address for ID:" + id));
        Check.arg((boolean)this.equals(addr.table), (String)"The ID doesn't match for this table!", (Object[])new Object[0]);
        return addr.row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] find(SearchCriteria criteria) {
        try {
            long[] ids;
            this.locker.globalReadLock();
            long[] lArray = ids = this.findBy(criteria).toArray();
            return lArray;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    private Numbers findBy(SearchCriteria criteria) {
        switch (criteria.kind()) {
            case CRITERION: {
                SearchCriterion crit = criteria.criterion();
                Op op = crit.op();
                Object value = crit.value();
                String columnName = crit.columnName();
                CustomIndex indexer = crit.indexer();
                Check.state((boolean)U.xor((columnName != null ? 1 : 0) != 0, (indexer != null ? 1 : 0) != 0), (String)"invalid search criteria", (Object[])new Object[0]);
                if (value instanceof Parameter) {
                    Parameter param = (Parameter)value;
                    throw Errors.illegalArgument((String)("Value not specified for parameter: " + param.name()), (Object[])new Object[0]);
                }
                if (op == Op.NEQ) {
                    SearchCriteria critGT;
                    SearchCriteria critLT;
                    if (columnName != null) {
                        critLT = SearchCriteriaImpl.single((String)columnName, (Op)Op.LT, (Object)value);
                        critGT = SearchCriteriaImpl.single((String)columnName, (Op)Op.GT, (Object)value);
                    } else {
                        critLT = SearchCriteriaImpl.single((CustomIndex)indexer, (Op)Op.LT, (Object)value);
                        critGT = SearchCriteriaImpl.single((CustomIndex)indexer, (Op)Op.GT, (Object)value);
                    }
                    return this.findBy(SearchCriteriaImpl.disjunction((SearchCriteria[])new SearchCriteria[]{critLT, critGT}));
                }
                if (columnName != null) {
                    Index index = this.indexOf(columnName);
                    Transformer<Object> tr = this.prop(columnName).getTransformer();
                    return index.find(op, tr.transform(value));
                }
                if (indexer instanceof IndexerImpl) {
                    IndexerImpl ind = (IndexerImpl)indexer;
                    Index index = ind.getIndex();
                    return index.find(op, value);
                }
                throw Errors.notExpected();
            }
            case CONJUNCTION: 
            case DISJUNCTION: {
                SearchCriteria[] crits = criteria.criteria();
                Numbers[] ids = new Numbers[crits.length];
                for (int i = 0; i < crits.length; ++i) {
                    ids[i] = this.findBy(crits[i]);
                }
                return criteria.kind() == SearchCriteriaKind.CONJUNCTION ? Nums.intersectAll((Numbers[])ids) : Nums.unionAll((Numbers[])ids);
            }
        }
        throw Errors.notExpected();
    }

    private Index indexOf(String column) {
        Index index = this.colInfo(column).getIndex();
        Check.state((index != null ? 1 : 0) != 0, (String)"The column %s doesn't have index!", (Object[])new Object[]{column});
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(E entity) {
        try {
            long id;
            this.locker.globalWriteLock();
            long l = id = this.insertRow(entity);
            return l;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(Map<String, Object> properties) {
        try {
            this.locker.globalWriteLock();
            E entity = this.newEntity();
            if (properties != null) {
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    PropertyInfo prop = this.info.getProperties().get(entry.getKey());
                    prop.set(entity, entry.getValue());
                }
            }
            long l = this.insertRow(entity);
            return l;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private long insertRow(E entity) {
        int n;
        boolean reuseRow;
        DatastoreTransaction tx = this.getTransaction();
        long id = this.idColl.newId();
        this.doTriggers(this.beforeInsert, TriggerAction.BEFORE_INSERT, id, null, entity);
        this.insider.inserting(this.clazz, id, entity);
        ++this.stats.inserts;
        Integer deletedRow = this.deleted.poll();
        boolean bl = reuseRow = deletedRow != null;
        if (reuseRow) {
            n = deletedRow;
        } else {
            int n2 = this.rows;
            n = n2;
            this.rows = n2 + 1;
        }
        int row = n;
        IdAddress addr = new IdAddress((Table)this, row);
        this.idColl.set(id, addr);
        ++this.size;
        this.ids.add(id);
        if (reuseRow) {
            this.records.set(row, this.newEntity());
        } else {
            this.records.add(this.newEntity());
        }
        this.changelog.add(TableChange.insertRow(id, row, reuseRow));
        if (entity != null) {
            for (PropertyInfo prop : this.props) {
                Object value = prop.get(entity);
                this.insertCell(tx, prop, id, row, value);
            }
        }
        this.setId(entity, id);
        this.doTriggers(this.afterInsert, TriggerAction.AFTER_INSERT, id, null, entity);
        this.insider.inserted(this.clazz, id, entity);
        this.finishTransaction(tx);
        return id;
    }

    private void revertInsertRow(long id, int row, boolean reuseRow) {
        this.insider.uninserting(this.clazz, id);
        this.idColl.cancelId(id);
        if (reuseRow) {
            this.deleted.add(row);
        } else {
            --this.rows;
        }
        this.idColl.delete(id);
        --this.size;
        this.ids.remove(id);
        if (!reuseRow) {
            this.records.remove(this.records.size() - 1);
        }
    }

    private void insertCell(DatastoreTransaction tx, PropertyInfo prop, long id, int row, Object value) {
        this.insider.insertingCell(this.clazz, id, prop.getName(), value);
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        column.set(row, value);
        if (index != null) {
            index.add(prop.getTransformer().transform(value), id);
        }
        this.changelog.add(TableChange.insertCell(prop, id, row, value));
        tx.changed(id);
    }

    private void revertInsertCell(PropertyInfo prop, long id, int row, Object value) {
        this.insider.uninsertingCell(this.clazz, id, prop.getName(), value);
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        column.delete(row);
        if (index != null) {
            Transformer<Object> tr = prop.getTransformer();
            index.remove(tr.transform(value), id);
        }
    }

    private Object setCell(DatastoreTransaction tx, long id, PropertyInfo prop, Object value, ComplexIndex<?>[] complexIndices) {
        int row = this.row(id);
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        Object oldValue = column.get(row);
        column.set(row, value);
        if (index != null) {
            Transformer<Object> tr = prop.getTransformer();
            index.remove(tr.transform(oldValue), id);
            index.add(tr.transform(value), id);
        }
        prop.appendComplexIndices(complexIndices);
        this.changelog.add(TableChange.set(id, prop, oldValue, value));
        tx.changed(id);
        return oldValue;
    }

    private void doComplexIndices(ComplexIndex<E>[] complexIndices, E oldEntity, E newEntity, long id) {
        for (int i = 0; i < complexIndices.length; ++i) {
            ComplexIndex<E> indx = complexIndices[i];
            if (indx == null) {
                return;
            }
            indx.remove(oldEntity, id);
            indx.add(newEntity, id);
        }
    }

    private void revertSetCell(long id, PropertyInfo prop, Object oldValue, Object value) {
        this.insider.unchanging(this.clazz, id, prop.getName(), oldValue, value);
        int row = this.row(id);
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        column.set(row, oldValue);
        if (index != null) {
            Transformer<Object> tr = prop.getTransformer();
            index.add(tr.transform(oldValue), id);
            index.remove(tr.transform(value), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long id) {
        try {
            this.locker.globalWriteLock();
            this.checkId(id);
            DatastoreTransaction tx = this.getTransaction();
            this.deleteInTx(tx, id);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private void deleteInTx(DatastoreTransaction tx, long id) {
        this.insider.deleting(this.clazz, id);
        E entity = this.get_(id);
        this.doTriggers(this.beforeDelete, TriggerAction.BEFORE_DELETE, id, entity, null);
        ++this.stats.deletes;
        int row = this.row(id);
        this.db.deleteRelsInTx(id, tx);
        --this.size;
        ++this.deletedCount;
        this.currentlyDeleted.add(row);
        this.idColl.delete(id);
        this.ids.remove(id);
        this.changelog.add(TableChange.delete(id, row));
        for (PropertyInfo prop : this.props) {
            this.deleteCell(tx, id, row, prop);
        }
        this.doTriggers(this.afterDelete, TriggerAction.AFTER_DELETE, id, entity, null);
        this.insider.deleted(this.clazz, id);
    }

    public void revertDelete(long id, int row) {
        this.insider.undeleting(this.clazz, id);
        ++this.size;
        --this.deletedCount;
        this.currentlyDeleted.clear();
        IdAddress addr = new IdAddress((Table)this, row);
        this.idColl.set(id, addr);
        this.ids.add(id);
    }

    private void deleteCell(DatastoreTransaction tx, long id, int row, PropertyInfo prop) {
        this.insider.deletingCell(this.clazz, id, prop.getName());
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        Object value = column.delete(row);
        if (index != null) {
            Transformer<Object> tr = prop.getTransformer();
            index.remove(tr.transform(value), id);
        }
        this.changelog.add(TableChange.deleteCell(id, prop, row, value));
        tx.delete(id);
    }

    public void revertDeleteCell(long id, int row, PropertyInfo prop, Object value) {
        this.insider.undeletingCell(this.clazz, id, prop.getName());
        Column column = prop.getColumn();
        Index index = prop.getIndex();
        column.set(row, value);
        if (index != null) {
            Transformer<Object> tr = prop.getTransformer();
            index.add(tr.transform(value), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        try {
            this.locker.globalReadLock();
            System.out.println("*** Table " + this.name() + " ***");
            for (long id : this.ids()) {
                E entity = this.get_(id);
                System.out.println(entity.toString());
            }
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.locker.globalReadLock();
            int n = this.size;
            return n;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long id, E entity) {
        try {
            this.locker.globalWriteLock();
            this.checkId(id);
            DatastoreTransaction tx = this.getTransaction();
            this.doUpdate(id, tx, entity);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(E entity) {
        try {
            this.locker.globalWriteLock();
            long id = U.getId(entity);
            this.checkId(id);
            DatastoreTransaction tx = this.getTransaction();
            this.doUpdate(id, tx, entity);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long id, Map<String, Object> properties) {
        try {
            this.locker.globalWriteLock();
            this.checkId(id);
            DatastoreTransaction tx = this.getTransaction();
            E entity = this.get_(id);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String col = entry.getKey();
                this.checkColumn(col);
                this.colInfo(col).set(entity, entry.getValue());
            }
            this.doUpdate(id, tx, entity);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long id, String col, Object value) {
        try {
            this.locker.globalWriteLock();
            this.checkId(id);
            this.checkColumn(col);
            DatastoreTransaction tx = this.getTransaction();
            this.insider.changing(this.clazz, id, col, value);
            E entity = this.get_(id);
            this.colInfo(col).set(entity, value);
            this.doUpdate(id, tx, entity);
            this.insider.changed(this.clazz, id, col, value);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private void doUpdate(long id, DatastoreTransaction tx, E entity) {
        E old = this.newEntity();
        E old2 = this.newEntity();
        E post = this.newEntity();
        this.get_(id, old, old2);
        this.doTriggers(this.beforeUpdate, TriggerAction.BEFORE_UPDATE, id, old, entity);
        for (int i = 0; i < this.tmpIndices.length && this.tmpIndices[i] != null; ++i) {
            this.tmpIndices[i] = null;
        }
        for (PropertyInfo pr : this.props) {
            Object val = pr.get(entity);
            this.setCell(tx, id, pr, val, this.tmpIndices);
        }
        this.doTriggers(this.afterUpdate, TriggerAction.AFTER_UPDATE, id, old, entity);
        this.get_(id, post);
        this.doComplexIndices(this.tmpIndices, old2, post, id);
    }

    private Object readCell(long id, String col) {
        int row = this.row(id);
        Column column = this.colInfo(col).getColumn();
        return column.get(row);
    }

    long getDeletedCount() {
        return this.deletedCount;
    }

    long getUnusedCount() {
        return this.deleted.size() + this.currentlyDeleted.size();
    }

    long getReuusedCount() {
        return this.deletedCount - this.getUnusedCount();
    }

    int mem() {
        return this.rows;
    }

    void revalidate() {
        Check.state((this.deletedCount >= this.getUnusedCount() ? 1 : 0) != 0, (String)"Inconsistent deleted count", (Object[])new Object[0]);
    }

    public E queryHelper() {
        return this.queryHelper;
    }

    public String nameOf(Object property) {
        return this.jokerator.decode(property);
    }

    @Override
    public void fill(long id, String columnName, Object value) {
        int row;
        boolean shouldInsert;
        boolean bl = shouldInsert = !this.idColl.has(id);
        if (shouldInsert) {
            this.idColl.registerId(id);
            row = this.rows++;
            this.idColl.set(id, new IdAddress((Table)this, row));
            ++this.size;
            this.records.add(this.newEntity());
            this.ids.add(id);
        } else {
            row = this.row(id);
        }
        this.checkId(id);
        this.checkColumn(columnName);
        PropertyInfo prop = this.colInfo(columnName);
        Column column = prop.getColumn();
        column.set(row, value);
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public void commit() {
        this.changelog.clear();
        this.deleted.addAll(this.currentlyDeleted);
        this.currentlyDeleted.clear();
    }

    @Override
    public void rollback() {
        block7: for (int i = this.changelog.size() - 1; i >= 0; --i) {
            TableChange change = this.changelog.get(i);
            switch (change.type) {
                case INSERT_ROW: {
                    this.revertInsertRow(change.id, change.row, change.reuseRow);
                    continue block7;
                }
                case INSERT_CELL: {
                    this.revertInsertCell(change.prop, change.id, change.row, change.value);
                    continue block7;
                }
                case SET_CELL: {
                    this.revertSetCell(change.id, change.prop, change.oldValue, change.value);
                    continue block7;
                }
                case DELETE: {
                    this.revertDelete(change.id, change.row);
                    continue block7;
                }
                case DELETE_CELL: {
                    this.revertDeleteCell(change.id, change.row, change.prop, change.value);
                    continue block7;
                }
                default: {
                    throw Errors.notExpected();
                }
            }
        }
        this.changelog.clear();
        this.currentlyDeleted.clear();
    }

    private DatastoreTransaction getTransaction() {
        Transaction transaction = this.transactor.getTransaction();
        if (transaction != null) {
            TransactionInternals internals = (TransactionInternals)transaction;
            return internals.getStoreTx();
        }
        return this.store.transaction();
    }

    private void finishTransaction(DatastoreTransaction tx) {
        Transaction transaction = this.transactor.getTransaction();
        if (transaction == null) {
            try {
                tx.commit();
                this.commit();
            }
            catch (Exception e) {
                System.out.println(" === EXCEPTION IN TRANSACTION: ===");
                e.printStackTrace();
                System.out.println(" === ROLLING BACK... ===");
                this.rollback();
            }
        }
    }

    @Override
    public Class<E> getClazz() {
        return this.clazz;
    }

    @Override
    public void setInsider(DbInsider insider) {
        this.insider = insider;
    }

    private IdAddress checkId(long id) {
        IdAddress address = this.idColl.get(id);
        if (address == null || address.table != this) {
            this.insider.invalidId(this.clazz, id);
            throw new InvalidIdException(id);
        }
        return address;
    }

    private boolean validColumn(String column) {
        boolean ok = this.info.getProperties().containsKey(column);
        if (!ok) {
            this.insider.invalidColumn(this.clazz, column);
        }
        return ok;
    }

    private void checkColumn(String column) {
        if (!this.validColumn(column)) {
            throw new InvalidColumnException(column);
        }
    }

    public Any<E> all() {
        return new AnySearch(this);
    }

    public long[] ids() {
        return Nums.arrFrom(this.ids);
    }

    @Override
    public void updateObj(Object entity) {
        this.update(entity);
    }

    @Override
    public JokerCreator jokerator() {
        return this.jokerator;
    }

    public Ids<E> withIds(long ... ids) {
        return new RecordsImpl(this, ids);
    }

    public E[] getAll(long ... ids) {
        Object[] arr = (Object[])Array.newInstance(this.clazz, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            arr[i] = this.get(ids[i]);
        }
        return arr;
    }

    public String toString() {
        return "TABLE<" + this.name() + ">";
    }

    public String name() {
        return this.clazz.getSimpleName();
    }

    public <T> void createIndexOn(T property) {
        this.createIndexOnNamed(this.jokerator.decode(property));
    }

    public void createIndexOnNamed(String propertyName) {
        this.createIndexOnNamed(propertyName, new Transformer<Object>(){

            public Object transform(Object value) {
                return value;
            }
        });
    }

    public <T> void createIndexOn(T property, Transformer<T> transformer) {
        this.createIndexOnNamed(this.jokerator.decode(property), transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createIndexOnNamed(String propertyName, Transformer<T> transformer) {
        try {
            long[] idss;
            this.locker.globalWriteLock();
            PropertyInfo prop = this.prop(propertyName);
            Index oldIndex = prop.getIndex();
            prop.setIndex(null);
            if (oldIndex != null) {
                oldIndex.dispose();
            }
            Transformer<T> tr = transformer;
            prop.setTransformer(tr);
            Index index = this.makeIndex();
            prop.setIndex(index);
            for (long id : idss = this.ids()) {
                Object value = this.read(id, propertyName);
                value = tr.transform(value);
                index.add(value, id);
            }
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    @Override
    public void forEach(Visitor<E> visitor) {
        this.forEach(this.ids(), visitor);
    }

    @Override
    public void forEach(long[] ids, Visitor<E> visitor) {
        E entity = this.newEntity();
        for (long id : ids) {
            this.get_(id, entity);
            if (!visitor.visit(entity)) continue;
            this.update(entity);
        }
    }

    private PropertyInfo prop(String propertyName) {
        PropertyInfo prop = this.info.getProperties().get(propertyName);
        Check.state((prop != null ? 1 : 0) != 0, (String)"Unknown property: %s", (Object[])new Object[]{propertyName});
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CustomIndex<E, T> index(Mapper<E, T> mapper, Object ... properties) {
        try {
            this.locker.globalWriteLock();
            IndexerImpl<E, T> indexerImpl = this.complexIndex(properties, mapper);
            return indexerImpl;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CustomIndex<E, T> multiIndex(Mapper<E, T[]> mapper, Object ... properties) {
        try {
            this.locker.globalWriteLock();
            IndexerImpl<E, T> indexerImpl = this.complexIndex(properties, mapper);
            return indexerImpl;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private <T> IndexerImpl<E, T> complexIndex(Object[] columns, Mapper<E, ?> mapper) {
        Index index = this.makeIndex();
        ComplexIndexImpl<E> complexIndex = new ComplexIndexImpl<E>(mapper, index);
        for (Object col : columns) {
            String colName = this.jokerator.decode(col);
            this.prop(colName).addComplexIndex(complexIndex);
        }
        this.allComplexIndices = (ComplexIndex[])U.expand((Object[])this.allComplexIndices, complexIndex);
        E entity = this.newEntity();
        for (long id : this.ids()) {
            this.get_(id, entity);
            complexIndex.add(entity, id);
        }
        return new IndexerImpl(complexIndex, index);
    }

    private Index makeIndex() {
        return new TreeIndex();
    }

    @Override
    public void addTrigger(TriggerAction action, Trigger<E> trigger) {
        switch (action) {
            case BEFORE_INSERT: {
                this.beforeInsert = (Trigger[])U.expand((Object[])this.beforeInsert, trigger);
                break;
            }
            case BEFORE_UPDATE: {
                this.beforeUpdate = (Trigger[])U.expand((Object[])this.beforeUpdate, trigger);
                break;
            }
            case BEFORE_DELETE: {
                this.beforeDelete = (Trigger[])U.expand((Object[])this.beforeDelete, trigger);
                break;
            }
            case BEFORE_READ: {
                this.beforeRead = (Trigger[])U.expand((Object[])this.beforeRead, trigger);
                break;
            }
            case AFTER_INSERT: {
                this.afterInsert = (Trigger[])U.expand((Object[])this.afterInsert, trigger);
                break;
            }
            case AFTER_UPDATE: {
                this.afterUpdate = (Trigger[])U.expand((Object[])this.afterUpdate, trigger);
                break;
            }
            case AFTER_DELETE: {
                this.afterDelete = (Trigger[])U.expand((Object[])this.afterDelete, trigger);
                break;
            }
            case AFTER_READ: {
                this.afterRead = (Trigger[])U.expand((Object[])this.afterRead, trigger);
                break;
            }
            default: {
                throw Errors.notExpected();
            }
        }
    }

    @Override
    public PropertyInfo[] props() {
        return this.props;
    }
}

