/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.abstracts.Index;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.api.Op;
import com.ohmdb.numbers.Nums;
import com.ohmdb.util.Errors;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeIndex
implements Index {
    private TreeMap<Object, SortedSet<Long>> map = new TreeMap();

    public void remove(Object oldValue, long id) {
        SortedSet<Long> set = this.map.get(oldValue);
        if (set != null) {
            set.remove(new Long(id));
        }
    }

    public void add(Object value, long id) {
        SortedSet<Long> set = this.map.get(value);
        if (set == null) {
            set = new TreeSet<Long>();
            this.map.put(value, set);
        }
        set.add(id);
    }

    public Numbers find(Op op, Object value) {
        switch (op) {
            case EQ: {
                SortedSet<Long> ids = this.map.get(value);
                return ids != null ? Nums.from(ids) : Nums.none();
            }
            case LT: {
                return Nums.union(this.map.headMap(value, false).values());
            }
            case LTE: {
                return Nums.union(this.map.headMap(value, true).values());
            }
            case GT: {
                return Nums.union(this.map.tailMap(value, false).values());
            }
            case GTE: {
                return Nums.union(this.map.tailMap(value, true).values());
            }
        }
        throw Errors.notExpected();
    }

    public void dispose() {
        this.map = null;
    }

    public String toString() {
        return "index";
    }
}

