/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.impl;

import com.ohmdb.api.Db;
import com.ohmdb.api.TriggerAction;
import com.ohmdb.api.TriggerCreator;
import com.ohmdb.api.TriggerOperation;
import com.ohmdb.impl.TriggerOperationImpl;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import java.util.Arrays;

public class TriggerCreatorImpl<E>
implements TriggerCreator<E> {
    private final Db db;
    private final Class<E> type;
    private final boolean before;
    private final TriggerAction[] actions;

    public TriggerCreatorImpl(Db db, Class<E> type, boolean before, TriggerAction ... actions) {
        this.db = db;
        this.type = type;
        this.before = before;
        this.actions = actions;
    }

    public TriggerOperation<E> inserted() {
        return this.op(this.before ? TriggerAction.BEFORE_INSERT : TriggerAction.AFTER_INSERT);
    }

    public TriggerOperation<E> updated() {
        return this.op(this.before ? TriggerAction.BEFORE_UPDATE : TriggerAction.AFTER_UPDATE);
    }

    public TriggerOperation<E> deleted() {
        return this.op(this.before ? TriggerAction.BEFORE_DELETE : TriggerAction.AFTER_DELETE);
    }

    public TriggerOperation<E> read() {
        return this.op(this.before ? TriggerAction.BEFORE_READ : TriggerAction.AFTER_READ);
    }

    private TriggerOperation<E> op(TriggerAction action) {
        if (U.indexOf((Object[])this.actions, (Object)action, (int)0) >= 0) {
            throw Errors.illegalArgument((String)("Duplicate trigger action: " + action), (Object[])new Object[0]);
        }
        TriggerAction[] mergedActions = Arrays.copyOf(this.actions, this.actions.length + 1);
        mergedActions[mergedActions.length - 1] = action;
        return new TriggerOperationImpl<E>(this.db, this.type, this.before, mergedActions);
    }
}

