/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.join;

import com.ohmdb.abstracts.FutureIds;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.api.JoinMode;
import com.ohmdb.dsl.join.AJoin;
import com.ohmdb.dsl.join.JoinInitializer;
import com.ohmdb.dsl.join.JoinSide;
import com.ohmdb.join.JoinBridgeImpl;
import com.ohmdb.join.JoinBridgeRel;
import com.ohmdb.join.futureid.IDS;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class DefaultJoinInitializer
implements JoinInitializer,
Comparator<JoinSide> {
    public static final DefaultJoinInitializer INSTANCE = new DefaultJoinInitializer();

    private DefaultJoinInitializer() {
    }

    public JoinSide[] optimize(AJoin[] joins, FutureIds[] futureIds) {
        JoinSide[] sides = this.setup(futureIds.length);
        this.verify(joins, sides);
        this.init(joins, futureIds, sides);
        this.initialize(joins, sides);
        return sides;
    }

    private void verify(AJoin[] joins, JoinSide[] sides) {
        for (AJoin join : joins) {
            Check.arg((join.from >= 0 && join.to >= 0 ? 1 : 0) != 0, (String)"Invalid join: %s", (Object[])new Object[]{join});
            Check.arg((join.from < sides.length && join.to < sides.length ? 1 : 0) != 0, (String)"Join references unspecified target: %s", (Object[])new Object[]{join});
        }
    }

    private void initialize(AJoin[] joins, JoinSide[] sides) {
        this.checkIsolated(sides);
        this.maybeSetIds(sides, joins);
        this.order(sides, joins);
        this.transferedPositions(sides, joins);
        this.initBeforeThem(sides);
        this.initBridges(sides);
    }

    private JoinSide[] setup(int length) {
        JoinSide[] sides = new JoinSide[length];
        for (int i = 0; i < sides.length; ++i) {
            sides[i] = new JoinSide(i);
        }
        return sides;
    }

    private void order(JoinSide[] sides, AJoin[] joins) {
        Arrays.sort(sides, this);
        for (int i = 0; i < sides.length; ++i) {
            sides[i].position = i;
        }
        HashSet<JoinSide> optional = new HashSet<JoinSide>();
        for (int i = 0; i < sides.length; ++i) {
            JoinSide side = sides[i];
            if (!side.futureIds.optional()) continue;
            optional.add(side);
            sides[i].position = Integer.MAX_VALUE;
        }
        while (!optional.isEmpty()) {
            int readyCount = sides.length - optional.size();
            JoinSide best = this.pickBestOptional(optional, sides, readyCount);
            optional.remove(best);
            sides[readyCount] = best;
            best.position = readyCount;
        }
    }

    private JoinSide pickBestOptional(Set<JoinSide> optional, JoinSide[] sides, int count) {
        Check.state((sides.length > 0 ? 1 : 0) != 0);
        JoinSide best = null;
        int maxFactor = -1;
        for (JoinSide side : optional) {
            int factor = 0;
            for (JoinSide related : side.related) {
                if (related.position >= count) continue;
                ++factor;
            }
            if (maxFactor >= factor) continue;
            maxFactor = factor;
            best = side;
        }
        return maxFactor > 0 ? best : optional.iterator().next();
    }

    private void transferedPositions(JoinSide[] sides, AJoin[] joins) {
        int[] trans = new int[sides.length];
        for (int i = 0; i < sides.length; ++i) {
            trans[sides[i].index] = i;
        }
        for (AJoin join : joins) {
            join.from2 = trans[join.from];
            join.to2 = trans[join.to];
        }
    }

    private void init(AJoin[] joins, FutureIds[] futureIds, JoinSide[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            JoinSide side = sides[i];
            side.futureIds = futureIds[i];
            for (AJoin join : joins) {
                if (join.from == i && join.to != i) {
                    side.froms.add(join);
                    side.joins.add(join);
                    side.related.add(sides[join.to]);
                    continue;
                }
                if (join.to == i && join.from != i) {
                    side.tos.add(join);
                    side.joins.add(join);
                    side.related.add(sides[join.from]);
                    continue;
                }
                if (join.from != i || join.to != i) continue;
                throw Errors.notSupported();
            }
        }
    }

    private void checkIsolated(JoinSide[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i].related.isEmpty()) continue;
            throw Errors.illegalArgument((String)"Isolated (non-related) join target: %s", (Object[])new Object[]{sides[i].futureIds});
        }
    }

    private boolean maybeSetIds(JoinSide[] sides, AJoin[] joins) {
        int withIds = 0;
        for (JoinSide side : sides) {
            if (side.futureIds.optional()) continue;
            ++withIds;
        }
        if (withIds == 0) {
            int minSize = Integer.MAX_VALUE;
            boolean minFrom = false;
            AJoin minJoin = null;
            for (AJoin join : joins) {
                int toN;
                int fromN = join.rel.fromSize();
                if (minSize >= fromN && this.inner(join.mode)) {
                    minSize = fromN;
                    minJoin = join;
                    minFrom = true;
                }
                if (minSize < (toN = join.rel.toSize()) || !this.inner(join.mode)) continue;
                minSize = toN;
                minJoin = join;
                minFrom = false;
            }
            if (minJoin != null) {
                Numbers ids;
                if (minFrom) {
                    ids = minJoin.rel.froms();
                    sides[minJoin.from].futureIds = IDS.futureIds((Numbers)ids);
                } else {
                    ids = minJoin.rel.tos();
                    sides[minJoin.to].futureIds = IDS.futureIds((Numbers)ids);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void initBeforeThem(JoinSide[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            JoinSide side = sides[i];
            for (JoinSide related : side.related) {
                if (related.position >= side.position) continue;
                side.before.add(related);
            }
        }
    }

    private void initBridges(JoinSide[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            JoinSide side = sides[i];
            HashSet<JoinBridgeRel> fromRels = new HashSet<JoinBridgeRel>();
            HashSet<JoinBridgeRel> toRels = new HashSet<JoinBridgeRel>();
            for (AJoin join : side.froms) {
                for (JoinSide pre : side.before) {
                    if (pre.index != join.to || !this.innerOrRight(join.mode)) continue;
                    fromRels.add(new JoinBridgeRel(join.rel, join.to2, join.mode));
                }
            }
            for (AJoin join : side.tos) {
                for (JoinSide pre : side.before) {
                    if (pre.index != join.from || !this.innerOrLeft(join.mode)) continue;
                    toRels.add(new JoinBridgeRel(join.rel, join.from2, join.mode));
                }
            }
            side.bridge = new JoinBridgeImpl(fromRels, toRels);
        }
    }

    private boolean inner(JoinMode mode) {
        return mode == JoinMode.INNER;
    }

    private boolean innerOrRight(JoinMode mode) {
        return mode == JoinMode.INNER || mode == JoinMode.RIGHT_OUTER;
    }

    private boolean innerOrLeft(JoinMode mode) {
        return mode == JoinMode.INNER || mode == JoinMode.LEFT_OUTER;
    }

    @Override
    public int compare(JoinSide s1, JoinSide s2) {
        return this.weight(s1.futureIds) - this.weight(s2.futureIds);
    }

    private int weight(FutureIds futureIds) {
        int weight = Math.min(futureIds.size(), 1000000000);
        if (futureIds.optional()) {
            weight += 1000000000;
        }
        return weight;
    }
}

