/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.join;

import com.ohmdb.abstracts.FutureIds;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.abstracts.ReadOnlyRelation;
import com.ohmdb.api.Links;
import com.ohmdb.dsl.join.AJoin;
import com.ohmdb.dsl.join.JoinConfig;
import com.ohmdb.dsl.join.JoinInitializer;
import com.ohmdb.dsl.join.JoinSide;
import com.ohmdb.dsl.join.LinkMatcher;
import com.ohmdb.join.DefaultJoinInitializer;
import com.ohmdb.links.LinksBuilder;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import com.ohmdb.util.UTILS;

public class DefaultLinkMatcher
implements LinkMatcher {
    public Links[] match(JoinConfig config) {
        Links[] links = new Links[config.getJoins().length];
        this.doMatch(config, links, false);
        return links;
    }

    public boolean exists(JoinConfig config) {
        boolean exists = this.doMatch(config, null, true);
        return exists;
    }

    private boolean doMatch(JoinConfig config, Links[] links, boolean exists) {
        boolean matched;
        config.initialize((JoinInitializer)DefaultJoinInitializer.INSTANCE);
        AJoin[] joins = config.getJoins();
        JoinSide[] sides = config.sides();
        int joinSize = joins.length;
        int tableSize = sides.length;
        LinksBuilder[] builders = null;
        if (!exists) {
            builders = new LinksBuilder[joinSize];
            for (int i = 0; i < builders.length; ++i) {
                builders[i] = UTILS.linkBuilder();
            }
        }
        switch (tableSize) {
            case 2: {
                matched = this.match2(joins, builders, sides, exists);
                break;
            }
            case 3: {
                matched = this.match3(joins, builders, sides, exists);
                break;
            }
            case 4: {
                matched = this.match4(joins, builders, sides, exists);
                break;
            }
            case 5: {
                matched = this.match5(joins, builders, sides, exists);
                break;
            }
            default: {
                throw Errors.notSupported();
            }
        }
        if (!exists) {
            for (int i = 0; i < links.length; ++i) {
                links[i] = builders[i].build();
            }
        }
        return matched;
    }

    private boolean match2(AJoin[] joins, LinksBuilder[] builders, JoinSide[] sides, boolean exists) {
        long[] combo = new long[2];
        JoinSide side1 = sides[1];
        Numbers src0 = sides[0].futureIds.fetch();
        for (int i0 = -1; i0 < src0.size(); ++i0) {
            combo[0] = i0 < 0 ? -1L : src0.at(i0);
            Numbers src1 = side1.bridge.reach(combo, 1, sides[1].futureIds);
            for (int i1 = -1; i1 < src1.size(); ++i1) {
                long l = combo[1] = i1 < 0 ? -1L : src1.at(i1);
                if (!this.check(joins, combo, builders, sides, exists) || !exists) continue;
                return true;
            }
        }
        return false;
    }

    private boolean match3(AJoin[] joins, LinksBuilder[] builders, JoinSide[] sides, boolean exists) {
        long[] combo = new long[3];
        JoinSide side1 = sides[1];
        JoinSide side2 = sides[2];
        Numbers src0 = sides[0].futureIds.fetch();
        for (int i0 = -1; i0 < src0.size(); ++i0) {
            combo[0] = i0 < 0 ? -1L : src0.at(i0);
            Numbers src1 = side1.bridge.reach(combo, 1, sides[1].futureIds);
            for (int i1 = -1; i1 < src1.size(); ++i1) {
                combo[1] = i1 < 0 ? -1L : src1.at(i1);
                Numbers src2 = side2.bridge.reach(combo, 2, sides[2].futureIds);
                for (int i2 = -1; i2 < src2.size(); ++i2) {
                    long l = combo[2] = i2 < 0 ? -1L : src2.at(i2);
                    if (!this.check(joins, combo, builders, sides, exists) || !exists) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean match4(AJoin[] joins, LinksBuilder[] builders, JoinSide[] sides, boolean exists) {
        long[] combo = new long[4];
        JoinSide side1 = sides[1];
        JoinSide side2 = sides[2];
        JoinSide side3 = sides[3];
        Numbers src0 = sides[0].futureIds.fetch();
        for (int i0 = -1; i0 < src0.size(); ++i0) {
            combo[0] = i0 < 0 ? -1L : src0.at(i0);
            Numbers src1 = side1.bridge.reach(combo, 1, sides[1].futureIds);
            for (int i1 = -1; i1 < src1.size(); ++i1) {
                combo[1] = i1 < 0 ? -1L : src1.at(i1);
                Numbers src2 = side2.bridge.reach(combo, 2, sides[2].futureIds);
                for (int i2 = -1; i2 < src2.size(); ++i2) {
                    combo[2] = i2 < 0 ? -1L : src2.at(i2);
                    Numbers src3 = side3.bridge.reach(combo, 3, sides[3].futureIds);
                    for (int i3 = -1; i3 < src3.size(); ++i3) {
                        long l = combo[3] = i3 < 0 ? -1L : src3.at(i3);
                        if (!this.check(joins, combo, builders, sides, exists) || !exists) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean match5(AJoin[] joins, LinksBuilder[] builders, JoinSide[] sides, boolean exists) {
        long[] combo = new long[5];
        JoinSide side1 = sides[1];
        JoinSide side2 = sides[2];
        JoinSide side3 = sides[3];
        JoinSide side4 = sides[4];
        Numbers src0 = sides[0].futureIds.fetch();
        for (int i0 = -1; i0 < src0.size(); ++i0) {
            combo[0] = i0 < 0 ? -1L : src0.at(i0);
            Numbers src1 = side1.bridge.reach(combo, 1, sides[1].futureIds);
            for (int i1 = -1; i1 < src1.size(); ++i1) {
                combo[1] = i1 < 0 ? -1L : src1.at(i1);
                Numbers src2 = side2.bridge.reach(combo, 2, sides[2].futureIds);
                for (int i2 = -1; i2 < src2.size(); ++i2) {
                    combo[2] = i2 < 0 ? -1L : src2.at(i2);
                    Numbers src3 = side3.bridge.reach(combo, 3, sides[3].futureIds);
                    for (int i3 = -1; i3 < src3.size(); ++i3) {
                        combo[3] = i3 < 0 ? -1L : src3.at(i3);
                        Numbers src4 = side4.bridge.reach(combo, 4, sides[4].futureIds);
                        for (int i4 = -1; i4 < src4.size(); ++i4) {
                            long l = combo[4] = i4 < 0 ? -1L : src4.at(i4);
                            if (!this.check(joins, combo, builders, sides, exists) || !exists) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean check(AJoin[] joins, long[] combo, LinksBuilder[] builders, JoinSide[] sides, boolean exists) {
        for (AJoin join : joins) {
            if (this.has(join, combo, sides)) continue;
            return false;
        }
        if (!exists) {
            for (AJoin join : joins) {
                builders[join.index].link(combo[join.from2], combo[join.to2]);
            }
        }
        return true;
    }

    private boolean has(AJoin join, long[] combo, JoinSide[] sides) {
        long from = combo[join.from2];
        long to = combo[join.to2];
        FutureIds fromIds = sides[join.from2].futureIds;
        FutureIds toIds = sides[join.to2].futureIds;
        Numbers filterFroms = fromIds.optional() ? null : fromIds.fetch();
        Numbers filterTos = toIds.optional() ? null : toIds.fetch();
        boolean lefty = to == -1L && from >= 0L && (filterTos == null || !join.rel.linksFrom(from).hasAny(filterTos));
        boolean righty = from == -1L && to >= 0L && (filterFroms == null || !join.rel.linksTo(to).hasAny(filterFroms));
        boolean linked = join.rel.hasLink(from, to);
        switch (join.mode) {
            case INNER: {
                return this.hasInfo(linked, from, to, join.rel);
            }
            case LEFT_OUTER: {
                return this.hasInfo(U.xor((boolean)lefty, (boolean)linked), from, to, join.rel);
            }
            case RIGHT_OUTER: {
                return this.hasInfo(U.xor((boolean)righty, (boolean)linked), from, to, join.rel);
            }
            case FULL_OUTER: {
                return this.hasInfo(U.xor((boolean)U.xor((boolean)lefty, (boolean)righty), (boolean)linked), from, to, join.rel);
            }
        }
        throw Errors.notExpected();
    }

    private boolean hasInfo(boolean rez, long from, long to, ReadOnlyRelation rel) {
        if (rez) {
            // empty if block
        }
        return rez;
    }
}

