/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.join;

import com.ohmdb.abstracts.FutureIds;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.api.JoinMode;
import com.ohmdb.dsl.join.JoinBridge;
import com.ohmdb.join.JoinBridgeRel;
import com.ohmdb.numbers.Nums;
import com.ohmdb.util.Check;
import java.util.Set;

public class JoinBridgeImpl
implements JoinBridge {
    private final Set<JoinBridgeRel> fromRels;
    private final Set<JoinBridgeRel> toRels;

    public JoinBridgeImpl(Set<JoinBridgeRel> fromRels, Set<JoinBridgeRel> toRels) {
        this.fromRels = fromRels;
        this.toRels = toRels;
        for (JoinBridgeRel bridgeRel : fromRels) {
            Check.arg((bridgeRel.mode == JoinMode.INNER || bridgeRel.mode == JoinMode.RIGHT_OUTER ? 1 : 0) != 0, (String)"wrong join type!", (Object[])new Object[0]);
        }
        for (JoinBridgeRel bridgeRel : toRels) {
            Check.arg((bridgeRel.mode == JoinMode.INNER || bridgeRel.mode == JoinMode.LEFT_OUTER ? 1 : 0) != 0, (String)"wrong join type!", (Object[])new Object[0]);
        }
    }

    public Numbers reach(long[] combo, int level, FutureIds futureIds) {
        Numbers filter;
        long id;
        Numbers src = futureIds.optional() ? null : futureIds.fetch();
        for (JoinBridgeRel bridgeRel : this.fromRels) {
            id = combo[bridgeRel.index];
            filter = bridgeRel.rel.linksTo(id);
            src = this.inter(src, filter);
        }
        for (JoinBridgeRel bridgeRel : this.toRels) {
            id = combo[bridgeRel.index];
            filter = bridgeRel.rel.linksFrom(id);
            src = this.inter(src, filter);
        }
        if (src == null) {
            src = futureIds.fetch();
        }
        return src;
    }

    private Numbers inter(Numbers src, Numbers filter) {
        return src != null ? Nums.intersect((Numbers)src, (Numbers)filter) : filter;
    }

    public String toString() {
        return "JoinBridge [fromRels=" + this.fromRels + ", toRels=" + this.toRels + "]";
    }
}

