/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.relation;

import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.abstracts.RWRelation;
import com.ohmdb.abstracts.RelationInternals;
import com.ohmdb.api.Table;
import com.ohmdb.relation.AbstractRelation;
import com.ohmdb.util.Errors;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InverseRelation<FROM, TO>
extends AbstractRelation<FROM, TO> {
    private final RelationInternals rel;

    public InverseRelation(RelationInternals rel) {
        this.rel = rel;
    }

    public RWRelation inverse() {
        return this.rel;
    }

    public boolean link(long fromId, long toId) {
        return this.rel.link(toId, fromId);
    }

    public boolean delink(long fromId, long toId) {
        return this.rel.delink(toId, fromId);
    }

    public void deleteFrom(long fromId) {
        this.rel.deleteTo(fromId);
    }

    public void deleteTo(long toId) {
        this.rel.deleteFrom(toId);
    }

    public void clear() {
        this.rel.clear();
    }

    public Numbers linksFrom(long id) {
        return this.rel.linksTo(id);
    }

    public Numbers linksTo(long id) {
        return this.rel.linksFrom(id);
    }

    public String info() {
        return "INVERSE OF: " + this.rel.info();
    }

    public String name() {
        return this.rel.name() + "_inversed";
    }

    public Table<?> from() {
        return this.rel.to();
    }

    public Table<?> to() {
        return this.rel.from();
    }

    public List<long[]> exportFromTo() {
        return this.rel.exportToFrom();
    }

    public List<long[]> exportToFrom() {
        return this.rel.exportFromTo();
    }

    public void commit() {
        this.rel.commit();
    }

    public void rollback() {
        this.rel.rollback();
    }

    public void fill(long from, long to) {
        this.rel.fill(to, from);
    }

    public int fromSize() {
        return this.rel.toSize();
    }

    public int toSize() {
        return this.rel.fromSize();
    }

    public void clearInTx(DatastoreTransaction tx) {
        this.rel.clearInTx(tx);
    }

    public void deleteFromInTx(long id, DatastoreTransaction tx) {
        this.rel.deleteToInTx(id, tx);
    }

    public void deleteToInTx(long id, DatastoreTransaction tx) {
        this.rel.deleteFromInTx(id, tx);
    }

    public ReentrantReadWriteLock getLock() {
        return this.rel.getLock();
    }

    public boolean hasLink(long from, long to) {
        return this.rel.hasLink(to, from);
    }

    public String toString() {
        return "inversed(" + this.rel.name() + ")";
    }

    public Numbers froms() {
        return this.rel.tos();
    }

    public Numbers tos() {
        return this.rel.froms();
    }

    public void kind(boolean symmetric, boolean manyFroms, boolean manyTos) {
        throw Errors.notExpected();
    }
}

