/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.relation;

import com.ohmdb.abstracts.DataStore;
import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.abstracts.IdColl;
import com.ohmdb.abstracts.LockManager;
import com.ohmdb.abstracts.Numbers;
import com.ohmdb.abstracts.RWRelation;
import com.ohmdb.api.Table;
import com.ohmdb.api.Transaction;
import com.ohmdb.impl.OhmDBStats;
import com.ohmdb.numbers.Nums;
import com.ohmdb.relation.AbstractRelation;
import com.ohmdb.relation.InverseRelation;
import com.ohmdb.relation.RelationChange;
import com.ohmdb.transaction.TransactionInternals;
import com.ohmdb.transaction.Transactor;
import com.ohmdb.util.Check;
import com.ohmdb.util.Errors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RelationImpl<FROM, TO>
extends AbstractRelation<FROM, TO> {
    private final SortedMap<Long, Numbers> left = new TreeMap<Long, Numbers>();
    private final String name;
    private final SortedMap<Long, Numbers> right = new TreeMap<Long, Numbers>();
    private final DataStore store;
    private final IdColl ids;
    private final Transactor transactor;
    private final LockManager locker;
    private final OhmDBStats stats;
    private final List<RelationChange> changelog = new ArrayList<RelationChange>(10000);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Table<FROM> from;
    private final Table<TO> to;
    private boolean symmetric;
    private boolean manyFroms = true;
    private boolean manyTos = true;
    private boolean hasKind;

    public RelationImpl(Table<FROM> from, String name, Table<TO> to, DataStore store, IdColl ids, Transactor transactor, LockManager lockManager, OhmDBStats stats, boolean symmetric, boolean manyFroms, boolean manyTos) {
        Check.arg((name != null ? 1 : 0) != 0, (String)"The relation name must be specified!", (Object[])new Object[0]);
        this.from = from;
        this.to = to;
        this.name = name;
        this.store = store;
        this.ids = ids;
        this.transactor = transactor;
        this.locker = lockManager;
        this.stats = stats;
        this.symmetric = symmetric;
        this.manyFroms = manyFroms;
        this.manyTos = manyTos;
        this.hasKind = true;
    }

    public RelationImpl(Table<FROM> from, String name, Table<TO> to, DataStore store, IdColl ids, Transactor transactor, LockManager lockManager, OhmDBStats stats) {
        Check.arg((name != null ? 1 : 0) != 0, (String)"The relation name must be specified!", (Object[])new Object[0]);
        this.from = from;
        this.to = to;
        this.name = name;
        this.store = store;
        this.ids = ids;
        this.transactor = transactor;
        this.locker = lockManager;
        this.stats = stats;
        this.hasKind = false;
    }

    private boolean link_(long from, long to) {
        Numbers leftLinks = this.leftNums(from);
        if (leftLinks.contains(to)) {
            return false;
        }
        Check.state((this.manyTos || leftLinks.size() == 0 ? 1 : 0) != 0, (String)"The ?-to-one relation %s already has link from %s", (Object[])new Object[]{this.name, from});
        leftLinks = leftLinks.with(to);
        this.left.put(from, leftLinks);
        Numbers rightLinks = this.rightNums(to);
        if (!this.symmetric) assert (!rightLinks.contains(from));
        Check.state((this.manyFroms || rightLinks.size() == 0 ? 1 : 0) != 0, (String)"The one-to-? relation %s already has link to %s", (Object[])new Object[]{this.name, to});
        rightLinks = rightLinks.with(from);
        this.rightish().put(to, rightLinks);
        return true;
    }

    private boolean delink_(long from, long to) {
        Numbers leftLinks = this.leftNums(from);
        if (!leftLinks.contains(to)) {
            return false;
        }
        if ((leftLinks = leftLinks.without(to)).size() > 0) {
            this.left.put(from, leftLinks);
        } else {
            this.left.remove(from);
        }
        Numbers rightLinks = this.rightNums(to);
        if (!this.symmetric) assert (rightLinks.contains(from));
        if ((rightLinks = rightLinks.without(from)).size() > 0) {
            this.rightish().put(to, rightLinks);
        } else {
            this.rightish().remove(to);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean link(long from, long to) {
        try {
            this.locker.globalWriteLock();
            this.nice("START LINKING " + this.name + ": " + from + " " + to);
            DatastoreTransaction tx = this.getTransaction();
            boolean changed = this.linkInTx(tx, from, to);
            this.finishTransaction(tx);
            this.nice("END LINKING " + this.name + ": " + from + " " + to);
            boolean bl = changed;
            return bl;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private boolean linkInTx(DatastoreTransaction tx, long from, long to) {
        this.insider.linking(this.name, from, to);
        boolean changed = this.link_(from, to);
        if (changed) {
            tx.changed(from);
            tx.changed(to);
            this.changelog.add(RelationChange.link(from, to));
        }
        this.insider.linked(this.name, from, to);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delink(long from, long to) {
        try {
            this.locker.globalWriteLock();
            DatastoreTransaction tx = this.getTransaction();
            boolean changed = this.delinkInTx(tx, from, to);
            this.finishTransaction(tx);
            boolean bl = changed;
            return bl;
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    private boolean delinkInTx(DatastoreTransaction tx, long from, long to) {
        this.insider.delinking(this.name, from, to);
        boolean changed = this.delink_(from, to);
        if (changed) {
            tx.changed(from);
            tx.changed(to);
            this.changelog.add(RelationChange.delink(from, to));
        }
        this.insider.delinked(this.name, from, to);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFrom(long id) {
        try {
            this.locker.globalWriteLock();
            DatastoreTransaction tx = this.getTransaction();
            this.insider.deletingLinksFrom(this.name, id);
            this.deleteFromInTx(id, tx);
            this.insider.deletedLinksFrom(this.name, id);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTo(long id) {
        try {
            this.locker.globalWriteLock();
            DatastoreTransaction tx = this.getTransaction();
            this.insider.deletingLinksTo(this.name, id);
            this.deleteToInTx(id, tx);
            this.insider.deletedLinksTo(this.name, id);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    public void deleteFromInTx(long fromId, DatastoreTransaction tx) {
        Numbers links = this.leftNums(fromId);
        for (long toId : links.toArray()) {
            this.delinkInTx(tx, fromId, toId);
        }
    }

    public void deleteToInTx(long toId, DatastoreTransaction tx) {
        Numbers links = this.rightNums(toId);
        for (long fromId : links.toArray()) {
            this.delinkInTx(tx, fromId, toId);
        }
    }

    public void fill(long fromId, long toId) {
        this.link_(fromId, toId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.locker.globalWriteLock();
            DatastoreTransaction tx = this.getTransaction();
            this.clearInTx(tx);
            this.finishTransaction(tx);
        }
        finally {
            this.locker.globalWriteUnlock();
        }
    }

    public void clearInTx(DatastoreTransaction tx) {
        for (long from : this.froms().toArray()) {
            this.deleteFromInTx(from, tx);
        }
    }

    public int fromSize() {
        return this.left.size();
    }

    public int toSize() {
        return this.rightish().size();
    }

    private Numbers leftNums(long id) {
        Numbers nums = (Numbers)this.left.get(id);
        return nums != null ? nums : Nums.none();
    }

    private Numbers rightNums(long id) {
        Numbers nums = (Numbers)this.rightish().get(id);
        return nums != null ? nums : Nums.none();
    }

    public String toString() {
        return this.name;
    }

    public String info() {
        String fromTo = this.from + " => " + this.name + " => " + this.to;
        return "=== RELATION " + fromTo + " (" + this.fromSize() + ":" + this.toSize() + ") ===\n" + RelationImpl.txt(this.left, "\n") + "\n===\n";
    }

    private static String txt(Map<Long, Numbers> map, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Long, Numbers> entry : map.entrySet()) {
            Long key = entry.getKey();
            Numbers arr = entry.getValue();
            String val = arr.toString();
            if (!first) {
                sb.append(sep);
            }
            sb.append(key);
            sb.append(" -> ");
            sb.append(val);
            first = false;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Numbers linksFrom(long id) {
        try {
            this.locker.globalReadLock();
            Numbers links = (Numbers)this.left.get(id);
            Numbers numbers = links != null ? links : Nums.none();
            return numbers;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Numbers linksTo(long id) {
        try {
            this.locker.globalReadLock();
            Numbers links = (Numbers)this.rightish().get(id);
            Numbers numbers = links != null ? links : Nums.none();
            return numbers;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    private DatastoreTransaction getTransaction() {
        Transaction transaction = this.transactor.getTransaction();
        if (transaction != null) {
            TransactionInternals internals = (TransactionInternals)transaction;
            return internals.getStoreTx();
        }
        return this.store.transaction();
    }

    private void finishTransaction(DatastoreTransaction tx) {
        Transaction transaction = this.transactor.getTransaction();
        if (transaction == null) {
            try {
                tx.commit();
                this.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.rollback();
            }
        }
    }

    private void nice(String msg) {
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public void commit() {
        this.changelog.clear();
    }

    public void rollback() {
        block4: for (int i = this.changelog.size() - 1; i >= 0; --i) {
            RelationChange change = this.changelog.get(i);
            switch (change.type) {
                case LINK: {
                    this.revertLink(change.from, change.to);
                    continue block4;
                }
                case DELINK: {
                    this.revertDelink(change.from, change.to);
                    continue block4;
                }
                default: {
                    throw Errors.notExpected();
                }
            }
        }
        this.changelog.clear();
    }

    private void revertLink(long from, long to) {
        this.delink_(from, to);
    }

    private void revertDelink(long from, long to) {
        this.link_(from, to);
    }

    public String name() {
        return this.name;
    }

    public Table<?> from() {
        return this.from;
    }

    public Table<?> to() {
        return this.to;
    }

    public List<long[]> exportFromTo() {
        return this.export(this.left);
    }

    public List<long[]> exportToFrom() {
        return this.export(this.rightish());
    }

    private List<long[]> export(SortedMap<Long, Numbers> map) {
        ArrayList<long[]> links = new ArrayList<long[]>();
        for (Map.Entry<Long, Numbers> entry : map.entrySet()) {
            long[] arr;
            long key = entry.getKey();
            for (long x : arr = entry.getValue().toArray()) {
                links.add(new long[]{key, x});
            }
        }
        return links;
    }

    public RWRelation inverse() {
        return new InverseRelation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLink(long from, long to) {
        try {
            this.locker.globalReadLock();
            boolean bl = this.leftNums(from).contains(to);
            return bl;
        }
        finally {
            this.locker.globalReadUnlock();
        }
    }

    public Numbers froms() {
        return Nums.fromArray((Object)this.left.keySet().toArray());
    }

    public Numbers tos() {
        return Nums.fromArray((Object)this.rightish().keySet().toArray());
    }

    public void kind(boolean symmetric, boolean manyFroms, boolean manyTos) {
        if (this.hasKind) {
            Check.state((this.symmetric == symmetric ? 1 : 0) != 0);
            Check.state((this.manyFroms == manyFroms ? 1 : 0) != 0);
            Check.state((this.manyTos == manyTos ? 1 : 0) != 0);
        } else {
            this.symmetric = symmetric;
            this.manyFroms = manyFroms;
            this.manyTos = manyTos;
            this.hasKind = true;
        }
    }

    private SortedMap<Long, Numbers> rightish() {
        return this.symmetric ? this.left : this.right;
    }
}

