/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.transaction;

import com.ohmdb.abstracts.DatastoreTransaction;
import com.ohmdb.api.Transaction;
import com.ohmdb.api.TransactionException;
import com.ohmdb.api.TransactionListener;
import com.ohmdb.transaction.TransactionInternals;
import com.ohmdb.transaction.TransactionStatus;
import com.ohmdb.transaction.Transactor;
import com.ohmdb.util.Errors;
import com.ohmdb.util.U;
import java.util.Arrays;

public class TransactionImpl
implements Transaction,
TransactionInternals,
TransactionListener {
    private final Transactor transactor;
    private final DatastoreTransaction storeTx;
    private TransactionStatus status = TransactionStatus.INITIAL;
    private volatile boolean finished = false;
    private volatile TransactionException failure;

    public TransactionImpl(Transactor transactor, DatastoreTransaction storeTx) {
        this.transactor = transactor;
        this.storeTx = storeTx;
    }

    public synchronized void begin() {
        this.expected(TransactionStatus.INITIAL);
        this.status = TransactionStatus.WAITING;
        this.transactor.begin(this);
        this.status = TransactionStatus.STARTED;
    }

    public synchronized void commit() {
        this.expected(TransactionStatus.STARTED);
        this.status = TransactionStatus.COMMITING;
        this.transactor.commit(this);
        this.status = TransactionStatus.COMMITED;
    }

    public synchronized void rollback() {
        this.expected(TransactionStatus.STARTED);
        this.status = TransactionStatus.ROLLING_BACK;
        this.transactor.rollback(this);
        this.status = TransactionStatus.ROLLED_BACK;
    }

    @Override
    public DatastoreTransaction getStoreTx() {
        return this.storeTx;
    }

    private void expected(TransactionStatus ... expectedStatuses) {
        for (TransactionStatus expected : expectedStatuses) {
            if (expected != this.status) continue;
            return;
        }
        Errors.illegalState((String)"Current transaction status is %s, but expected statuses are: %s", (Object[])new Object[]{this.status, Arrays.toString((Object[])expectedStatuses)});
    }

    public void addListener(TransactionListener listener) {
        this.storeTx.addListener(listener);
    }

    public void sync() throws TransactionException {
        this.addListener(this);
        while (!this.finished) {
            U.sleep((long)5L);
        }
        if (this.failure != null) {
            throw this.failure;
        }
    }

    public void onSuccess() {
        this.finished = true;
    }

    public void onError(Exception e) {
        this.finished = true;
        this.failure = new TransactionException(e);
    }
}

