/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.transaction;

import com.ohmdb.abstracts.LockManager;
import com.ohmdb.api.Transaction;
import com.ohmdb.impl.OhmDBImpl;
import com.ohmdb.impl.OhmDBStats;
import com.ohmdb.transaction.TransactionInternals;
import com.ohmdb.transaction.Transactor;
import com.ohmdb.util.Check;

public class TransactorImpl
implements Transactor {
    private final OhmDBImpl db;
    private final LockManager lockManager;
    private final OhmDBStats stats;
    private Transaction transaction;

    public TransactorImpl(OhmDBImpl db, LockManager lockManager, OhmDBStats stats) {
        this.db = db;
        this.lockManager = lockManager;
        this.stats = stats;
    }

    @Override
    public void begin(Transaction transaction) {
        this.lockManager.globalWriteLock();
        ++this.stats.transactions;
        this.transaction = transaction;
    }

    @Override
    public void rollback(Transaction transaction) {
        Check.arg((this.transaction == transaction ? 1 : 0) != 0, (String)"Invalid transaction!", (Object[])new Object[0]);
        this.db.rollback();
        TransactionInternals internals = (TransactionInternals)transaction;
        internals.getStoreTx().rollback();
        this.transaction = null;
        ++this.stats.rollbacks;
        this.lockManager.globalWriteUnlock();
    }

    @Override
    public void commit(Transaction transaction) {
        Check.arg((this.transaction == transaction ? 1 : 0) != 0, (String)"Invalid transaction!", (Object[])new Object[0]);
        this.db.commit();
        TransactionInternals internals = (TransactionInternals)transaction;
        internals.getStoreTx().commit();
        this.transaction = null;
        ++this.stats.commits;
        this.lockManager.globalWriteUnlock();
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }
}

