/*
 * Decompiled with CFR 0.152.
 */
package com.ohmdb.util;

import com.ohmdb.abstracts.Numbers;
import com.ohmdb.abstracts.RWRelation;
import com.ohmdb.abstracts.RelationInternals;
import com.ohmdb.api.Links;
import com.ohmdb.exception.OhmDBException;
import com.ohmdb.links.LinksBuilder;
import com.ohmdb.links.LinksImpl;
import com.ohmdb.links.NoLinks;
import com.ohmdb.numbers.Nums;
import com.ohmdb.util.U;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

public class UTILS {
    public static final boolean PROD = false;
    public static final Links NO_PATHS = new NoLinks();

    public static OhmDBException err(String msg) {
        return new OhmDBException(msg);
    }

    public static void link(RWRelation rel, long from, Numbers tos) {
        for (long to : tos.toArray()) {
            rel.link(from, to);
        }
    }

    public static void delink(RWRelation rel, long from, Numbers tos) {
        for (long to : tos.toArray()) {
            rel.delink(from, to);
        }
    }

    public static void link(RelationInternals rel, Numbers froms, long to) {
        for (long from : froms.toArray()) {
            rel.link(from, to);
        }
    }

    public static void delink(RelationInternals rel, Numbers froms, long to) {
        for (long from : froms.toArray()) {
            rel.delink(from, to);
        }
    }

    public static boolean equal(Links[] l1, Links[] l2) {
        if (l1.length != l2.length) {
            return false;
        }
        for (int i = 0; i < l1.length; ++i) {
            if (UTILS.equal(l1[i], l2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Links p1, Links p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.size() != p2.size()) {
            return false;
        }
        int size = p1.size();
        for (int i = 0; i < size; ++i) {
            if (p1.from(i) == p2.from(i) && Arrays.equals(p1.to(i), p2.to(i))) continue;
            return false;
        }
        return true;
    }

    public static String toString(Links paths) {
        if (paths == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paths.from(i));
            long[] nums = paths.to(i);
            if (nums == null) continue;
            sb.append(" : ");
            sb.append(U.text((Object)nums));
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Links from(long[] keys, long[][] related) {
        assert (keys.length == related.length);
        assert (Nums.validate((long[])keys, (int)0, (int)keys.length));
        return new LinksImpl(keys, related);
    }

    public static Links linksFromTos(long[][] fromTos) {
        int size = fromTos.length;
        long[] keys = new long[size];
        long[][] numbers = new long[size][];
        for (int i = 0; i < size; ++i) {
            long[] fromTo = fromTos[i];
            keys[i] = fromTo[0];
            int len = fromTo.length - 1;
            numbers[i] = new long[len];
            System.arraycopy(fromTo, 1, numbers[i], 0, len);
        }
        return UTILS.from(keys, numbers);
    }

    public static Links linksFrom(SortedMap<Long, SortedSet<Long>> links) {
        int size = links.size();
        long[] keys = new long[size];
        long[][] numbers = new long[size][];
        int i = 0;
        for (Map.Entry<Long, SortedSet<Long>> fromTo : links.entrySet()) {
            keys[i] = fromTo.getKey();
            SortedSet<Long> values = fromTo.getValue();
            numbers[i] = Nums.arrFrom(values);
            ++i;
        }
        return UTILS.from(keys, numbers);
    }

    public static LinksBuilder linkBuilder() {
        return new LinksBuilder();
    }
}

