/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.impl.client;

import com.okta.authn.sdk.AuthenticationException;
import com.okta.authn.sdk.AuthenticationFailureException;
import com.okta.authn.sdk.AuthenticationStateHandler;
import com.okta.authn.sdk.CredentialsException;
import com.okta.authn.sdk.FactorValidationException;
import com.okta.authn.sdk.InvalidAuthenticationStateException;
import com.okta.authn.sdk.InvalidRecoveryAnswerException;
import com.okta.authn.sdk.InvalidTokenException;
import com.okta.authn.sdk.InvalidUserException;
import com.okta.authn.sdk.client.AuthenticationClient;
import com.okta.authn.sdk.http.Header;
import com.okta.authn.sdk.http.QueryParameter;
import com.okta.authn.sdk.http.RequestContext;
import com.okta.authn.sdk.resource.ActivateFactorRequest;
import com.okta.authn.sdk.resource.AuthenticationRequest;
import com.okta.authn.sdk.resource.AuthenticationResponse;
import com.okta.authn.sdk.resource.AuthenticationStatus;
import com.okta.authn.sdk.resource.ChallengeFactorRequest;
import com.okta.authn.sdk.resource.ChangePasswordRequest;
import com.okta.authn.sdk.resource.FactorEnrollRequest;
import com.okta.authn.sdk.resource.FactorProfile;
import com.okta.authn.sdk.resource.FactorProvider;
import com.okta.authn.sdk.resource.FactorType;
import com.okta.authn.sdk.resource.RecoverPasswordRequest;
import com.okta.authn.sdk.resource.RecoveryQuestionAnswerRequest;
import com.okta.authn.sdk.resource.StateTokenRequest;
import com.okta.authn.sdk.resource.UnlockAccountRequest;
import com.okta.authn.sdk.resource.VerifyFactorRequest;
import com.okta.authn.sdk.resource.VerifyRecoverTokenRequest;
import com.okta.authn.sdk.resource.VerifyRecoveryRequest;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.impl.client.BaseClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.ResourceException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultAuthenticationClient
extends BaseClient
implements AuthenticationClient {
    public DefaultAuthenticationClient(ClientConfiguration clientConfiguration) {
        super(clientConfiguration, Caches.newDisabledCacheManager());
    }

    public AuthenticationResponse authenticate(String username, char[] password, String relayState, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.authenticate(((AuthenticationRequest)this.instantiate(AuthenticationRequest.class)).setUsername(username).setPassword(password).setRelayState(relayState), stateHandler);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse changePassword(char[] oldPassword, char[] newPassword, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.changePassword(((ChangePasswordRequest)this.instantiate(ChangePasswordRequest.class)).setOldPassword(oldPassword).setNewPassword(newPassword).setStateToken(stateToken), stateHandler);
    }

    public AuthenticationResponse changePassword(ChangePasswordRequest changePasswordRequest, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/credentials/change_password", (Resource)changePasswordRequest, stateHandler, requestContext);
    }

    public AuthenticationResponse resetPassword(char[] newPassword, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.resetPassword(((ChangePasswordRequest)this.instantiate(ChangePasswordRequest.class)).setStateToken(stateToken).setNewPassword(newPassword), stateHandler);
    }

    public AuthenticationResponse resetPassword(ChangePasswordRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/credentials/reset_password", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse recoverPassword(String username, FactorType factorType, String relayState, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.recoverPassword(((RecoverPasswordRequest)this.instantiate(RecoverPasswordRequest.class)).setUsername(username).setFactorType(factorType).setRelayState(relayState), stateHandler);
    }

    public AuthenticationResponse recoverPassword(RecoverPasswordRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/recovery/password", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse challengeFactor(String factorId, String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        ChallengeFactorRequest request = ((ChallengeFactorRequest)this.instantiate(ChallengeFactorRequest.class)).setStateToken(stateToken);
        String href = "/api/v1/authn/factors/" + factorId + "/verify";
        return this.doPost(href, (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse verifyFactor(String factorId, String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.challengeFactor(factorId, stateToken, requestContext, stateHandler);
    }

    public AuthenticationResponse verifyFactor(String factorId, VerifyFactorRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors/" + factorId + "/verify", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse activateFactor(String factorId, ActivateFactorRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors/" + factorId + "/lifecycle/activate", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse verifyUnlockAccount(FactorType factorType, VerifyRecoveryRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/recovery/factors/" + factorType.name() + "/verify", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse unlockAccount(String username, FactorType factorType, String relayState, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.unlockAccount(((UnlockAccountRequest)this.instantiate(UnlockAccountRequest.class)).setUsername(username).setFactorType(factorType).setRelayState(relayState), stateHandler);
    }

    public AuthenticationResponse unlockAccount(UnlockAccountRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/recovery/unlock", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse answerRecoveryQuestion(String answer, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.answerRecoveryQuestion(((RecoveryQuestionAnswerRequest)this.instantiate(RecoveryQuestionAnswerRequest.class)).setAnswer(answer).setStateToken(stateToken), stateHandler);
    }

    public AuthenticationResponse answerRecoveryQuestion(RecoveryQuestionAnswerRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/recovery/answer", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse enrollFactor(FactorType type, FactorProvider provider, FactorProfile factorProfile, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.enrollFactor(((FactorEnrollRequest)this.instantiate(FactorEnrollRequest.class)).setFactorType(type).setProvider(provider).setFactorProfile(factorProfile).setStateToken(stateToken), stateHandler);
    }

    public AuthenticationResponse enrollFactor(FactorEnrollRequest request, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors", (Resource)request, stateHandler, requestContext);
    }

    public AuthenticationResponse previous(String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/previous", (Resource)this.toRequest(stateToken), stateHandler, requestContext);
    }

    public AuthenticationResponse skip(String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/skip", (Resource)this.toRequest(stateToken), stateHandler, requestContext);
    }

    public AuthenticationResponse cancel(String stateToken, RequestContext requestContext) throws AuthenticationException {
        return this.doPost("/api/v1/authn/cancel", (Resource)this.toRequest(stateToken), null, requestContext);
    }

    public AuthenticationResponse resendActivateFactor(String factorId, String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors/" + factorId + "/lifecycle/resend", (Resource)this.toRequest(stateToken), stateHandler, requestContext);
    }

    public AuthenticationResponse resendVerifyFactor(String factorId, String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors/" + factorId + "/verify/resend", (Resource)this.toRequest(stateToken), stateHandler, requestContext);
    }

    public AuthenticationResponse verifyActivation(String factorId, String stateToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.doPost("/api/v1/authn/factors/" + factorId + "/lifecycle/activate/poll", (Resource)this.toRequest(stateToken), stateHandler, requestContext);
    }

    public AuthenticationResponse verifyRecoveryToken(String recoveryToken, RequestContext requestContext, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        VerifyRecoverTokenRequest request = ((VerifyRecoverTokenRequest)this.instantiate(VerifyRecoverTokenRequest.class)).setRecoveryToken(recoveryToken);
        return this.doPost("/api/v1/authn/recovery/token", (Resource)request, stateHandler, requestContext);
    }

    private StateTokenRequest toRequest(String stateToken) {
        return ((StateTokenRequest)this.instantiate(StateTokenRequest.class)).setStateToken(stateToken);
    }

    private void handleResult(AuthenticationResponse authenticationResponse, AuthenticationStateHandler authenticationStateHandler) {
        AuthenticationStatus status = authenticationResponse.getStatus();
        switch (status) {
            case SUCCESS: {
                authenticationStateHandler.handleSuccess(authenticationResponse);
                break;
            }
            case LOCKED_OUT: {
                authenticationStateHandler.handleLockedOut(authenticationResponse);
                break;
            }
            case MFA_CHALLENGE: {
                authenticationStateHandler.handleMfaChallenge(authenticationResponse);
                break;
            }
            case MFA_ENROLL: {
                authenticationStateHandler.handleMfaEnroll(authenticationResponse);
                break;
            }
            case MFA_ENROLL_ACTIVATE: {
                authenticationStateHandler.handleMfaEnrollActivate(authenticationResponse);
                break;
            }
            case MFA_REQUIRED: {
                authenticationStateHandler.handleMfaRequired(authenticationResponse);
                break;
            }
            case PASSWORD_EXPIRED: {
                authenticationStateHandler.handlePasswordExpired(authenticationResponse);
                break;
            }
            case PASSWORD_RESET: {
                authenticationStateHandler.handlePasswordReset(authenticationResponse);
                break;
            }
            case PASSWORD_WARN: {
                authenticationStateHandler.handlePasswordWarning(authenticationResponse);
                break;
            }
            case RECOVERY: {
                authenticationStateHandler.handleRecovery(authenticationResponse);
                break;
            }
            case RECOVERY_CHALLENGE: {
                authenticationStateHandler.handleRecoveryChallenge(authenticationResponse);
                break;
            }
            case UNAUTHENTICATED: {
                authenticationStateHandler.handleUnauthenticated(authenticationResponse);
                break;
            }
            default: {
                authenticationStateHandler.handleUnknown(authenticationResponse);
            }
        }
    }

    private AuthenticationResponse doPost(String href, Resource request, AuthenticationStateHandler authenticationStateHandler, RequestContext requestContext) throws AuthenticationException {
        try {
            Map<String, Object> query = null;
            Map<String, List> headers = null;
            if (requestContext != null) {
                query = requestContext.getQueryParams().stream().collect(Collectors.toMap(rec$ -> (String)((QueryParameter)rec$).getKey(), rec$ -> ((QueryParameter)rec$).getValue()));
                headers = requestContext.getHeaders().stream().collect(Collectors.toMap(rec$ -> (String)((Header)rec$).getKey(), rec$ -> (List)((Header)rec$).getValue(), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList())));
            }
            AuthenticationResponse authenticationResponse = (AuthenticationResponse)this.getDataStore().create(href, request, null, AuthenticationResponse.class, query, headers);
            if (authenticationStateHandler != null) {
                this.handleResult(authenticationResponse, authenticationStateHandler);
            }
            return authenticationResponse;
        }
        catch (ResourceException e) {
            this.translateException(e);
            throw e;
        }
    }

    private void translateException(ResourceException resourceException) throws AuthenticationException {
        String errorCode;
        switch (errorCode = resourceException.getCode()) {
            case "E0000004": {
                throw new AuthenticationFailureException(resourceException);
            }
            case "E0000014": {
                throw new CredentialsException(resourceException);
            }
            case "E0000068": {
                throw new FactorValidationException(resourceException);
            }
            case "E0000079": {
                throw new InvalidAuthenticationStateException(resourceException);
            }
            case "E0000087": {
                throw new InvalidRecoveryAnswerException(resourceException);
            }
            case "E0000011": {
                throw new InvalidTokenException(resourceException);
            }
            case "E0000095": {
                throw new InvalidUserException(resourceException);
            }
        }
        throw resourceException;
    }
}

