/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.configcheck;

import com.okta.commons.configcheck.ValidationResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationValidator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationValidator.class);
    private static final ResourceBundle ERRORS = ResourceBundle.getBundle("com/okta/commons/configcheck/ConfigurationValidator");

    private ConfigurationValidator() {
    }

    public static void assertOrgUrl(String url) {
        ConfigurationValidator.validateOrgUrl(url).ifInvalidThrow();
    }

    @Deprecated
    public static void assertOrgUrl(String url, boolean allowNonHttpsForTesting) {
        ConfigurationValidator.validateOrgUrl(url, allowNonHttpsForTesting).ifInvalidThrow();
    }

    public static ValidationResponse validateOrgUrl(String url) {
        return ConfigurationValidator.validateHttpsUrl(url, "orgUrl", false);
    }

    @Deprecated
    public static ValidationResponse validateOrgUrl(String url, boolean allowNonHttpsForTesting) {
        return ConfigurationValidator.validateHttpsUrl(url, "orgUrl", allowNonHttpsForTesting);
    }

    public static void assertApiToken(String token) {
        ConfigurationValidator.validateApiToken(token).ifInvalidThrow();
    }

    public static ValidationResponse validateApiToken(String token) {
        ValidationResponse response = new ValidationResponse();
        if (!ConfigurationValidator.hasText(token)) {
            response.setMessage(ERRORS.getString("apiToken.missing"));
        } else if (ConfigurationValidator.containsCaseInsensitive(token, "{apitoken}")) {
            response.setMessage(ERRORS.getString("apiToken.containsBrackets"));
        }
        return response;
    }

    public static void assertIssuer(String url) {
        ConfigurationValidator.validateIssuer(url).ifInvalidThrow();
    }

    public static ValidationResponse validateIssuer(String url) {
        return ConfigurationValidator.validateHttpsUrl(url, "issuerUrl", false);
    }

    public static void assertClientId(String clientId) {
        ConfigurationValidator.validateClientId(clientId).ifInvalidThrow();
    }

    public static ValidationResponse validateClientId(String clientId) {
        ValidationResponse response = new ValidationResponse();
        if (!ConfigurationValidator.hasText(clientId)) {
            response.setMessage(ERRORS.getString("clientId.missing"));
        } else if (ConfigurationValidator.containsCaseInsensitive(clientId, "{clientid}")) {
            response.setMessage(ERRORS.getString("clientId.containsBrackets"));
        }
        return response;
    }

    public static void assertClientSecret(String clientSecret) {
        ConfigurationValidator.validateClientSecret(clientSecret).ifInvalidThrow();
    }

    public static ValidationResponse validateClientSecret(String clientSecret) {
        ValidationResponse response = new ValidationResponse();
        if (!ConfigurationValidator.hasText(clientSecret)) {
            response.setMessage(ERRORS.getString("clientSecret.missing"));
        } else if (ConfigurationValidator.containsCaseInsensitive(clientSecret, "{clientsecret}")) {
            response.setMessage(ERRORS.getString("clientSecret.containsBrackets"));
        }
        return response;
    }

    private static String formattedErrorMessage(String messageKey, Object ... args) {
        String message = ERRORS.getString(messageKey);
        return MessageFormat.format(message, args);
    }

    private static ValidationResponse validateHttpsUrl(String url, String keyPrefix, boolean allowNonHttps) {
        ValidationResponse response = new ValidationResponse();
        if (!ConfigurationValidator.hasText(url)) {
            response.setMessage(ERRORS.getString(keyPrefix + ".missing"));
        } else if (ConfigurationValidator.containsCaseInsensitive(url, "{youroktadomain}")) {
            response.setMessage(ERRORS.getString(keyPrefix + ".containsBrackets"));
        } else {
            try {
                URL tempUrl = new URL(url);
                String host = tempUrl.getHost().toLowerCase(Locale.ENGLISH);
                if (!"https".equalsIgnoreCase(tempUrl.getProtocol())) {
                    if (allowNonHttps) {
                        logger.warn(ERRORS.getString("httpsCheck.disabled"));
                    } else {
                        response.setMessage(ConfigurationValidator.formattedErrorMessage(keyPrefix + ".nonHttpsInvalid", url));
                    }
                } else if (host.endsWith(".com.com")) {
                    response.setMessage(ConfigurationValidator.formattedErrorMessage(keyPrefix + ".invalid", url));
                } else if (host.endsWith("-admin.okta.com") || host.endsWith("-admin.oktapreview.com") || host.endsWith("-admin.okta-emea.com")) {
                    response.setMessage(ConfigurationValidator.formattedErrorMessage(keyPrefix + ".containsAdmin", url));
                }
            }
            catch (MalformedURLException e) {
                response.setMessage(ConfigurationValidator.formattedErrorMessage(keyPrefix + ".invalid", url)).setException(e);
            }
        }
        return response;
    }

    private static boolean containsCaseInsensitive(String textToSearch, String substring) {
        return ConfigurationValidator.hasLength(textToSearch) && ConfigurationValidator.hasLength(substring) && textToSearch.toLowerCase(Locale.ENGLISH).contains(substring);
    }

    private static boolean hasText(CharSequence str) {
        if (!ConfigurationValidator.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }
}

