/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http.httpclient;

import com.okta.commons.http.DefaultResponse;
import com.okta.commons.http.HttpException;
import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.MediaType;
import com.okta.commons.http.Request;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.Response;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.http.httpclient.HttpClientRequestFactory;
import com.okta.commons.lang.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestExecutor
implements RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final String MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxPerRoute";
    private static final String MAX_CONNECTIONS_TOTAL_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxTotal";
    private static final String CONNECTION_VALIDATION_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.validateAfterInactivity";
    private static final String CONNECTION_TIME_TO_LIVE_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.timeToLive";
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 0x3FFFFFFF;
    private static final int DEFAULT_MAX_CONNECTIONS_TOTAL = Integer.MAX_VALUE;
    private static final int DEFAULT_CONNECTION_VALIDATION_INACTIVITY = 2000;
    private static final int DEFAULT_CONNECTION_TIME_TO_LIVE = 300000;
    private final RequestAuthenticator requestAuthenticator;
    private HttpClient httpClient;
    private HttpClientRequestFactory httpClientRequestFactory;
    private final Map<String, Integer> requestExecutorParams = new HashMap<String, Integer>();

    public HttpClientRequestExecutor(HttpClientConfiguration clientConfiguration) {
        Proxy proxy = clientConfiguration.getProxy();
        Integer connectionTimeout = clientConfiguration.getConnectionTimeout();
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        this.requestAuthenticator = clientConfiguration.getRequestAuthenticator();
        this.parseRequestExecutorParams(clientConfiguration.getRequestExecutorParams());
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager((long)this.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        connMgr.setValidateAfterInactivity(this.getMaxConnectionInactivity());
        if (this.getMaxConnectionTotal() >= this.getMaxConnectionPerRoute()) {
            connMgr.setDefaultMaxPerRoute(this.getMaxConnectionPerRoute());
            connMgr.setMaxTotal(this.getMaxConnectionTotal());
        } else {
            connMgr.setDefaultMaxPerRoute(0x3FFFFFFF);
            connMgr.setMaxTotal(Integer.MAX_VALUE);
            log.warn("{} ({}) is less than {} ({}). Reverting to defaults: connectionMaxTotal ({}) and connectionMaxPerRoute ({}).", new Object[]{MAX_CONNECTIONS_TOTAL_PROPERTY_KEY, this.getMaxConnectionTotal(), MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY, this.getMaxConnectionPerRoute(), Integer.MAX_VALUE, 0x3FFFFFFF});
        }
        int connectionTimeoutAsMilliseconds = connectionTimeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeoutAsMilliseconds).setSocketTimeout(connectionTimeoutAsMilliseconds).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).disableCookieManagement().setDefaultConnectionConfig(connectionConfig).setConnectionManager((HttpClientConnectionManager)connMgr);
        this.httpClientRequestFactory = new HttpClientRequestFactory(requestConfig);
        if (proxy != null) {
            HttpHost httpProxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            httpClientBuilder.setProxy(httpProxyHost);
            if (proxy.isAuthenticationRequired()) {
                AuthScope authScope = new AuthScope(proxy.getHost(), proxy.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                BasicCredentialsProvider credentialsProviderProvider = new BasicCredentialsProvider();
                credentialsProviderProvider.setCredentials(authScope, (Credentials)credentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProviderProvider);
            }
        }
        httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        this.httpClient = httpClientBuilder.build();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Response executeRequest(Request request) throws HttpException {
        Assert.notNull((Object)request, (String)"Request argument cannot be null.");
        HttpResponse httpResponse = null;
        this.requestAuthenticator.authenticate(request);
        HttpRequestBase httpRequest = this.httpClientRequestFactory.createHttpClientRequest(request, null);
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            Response response = this.toSdkResponse(httpResponse);
            return response;
        }
        catch (SocketException | SocketTimeoutException | NoHttpResponseException | ConnectTimeoutException e) {
            throw new HttpException("Unable to execute HTTP request - retryable exception: " + e.getMessage(), e, true);
        }
        catch (IOException e) {
            throw new HttpException("Unable to execute HTTP request: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                httpResponse.getEntity().getContent().close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected byte[] toBytes(HttpEntity entity) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    protected Response toSdkResponse(HttpResponse httpResponse) throws IOException {
        long contentLength;
        InputStream body;
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        HttpHeaders headers = this.getHeaders(httpResponse);
        MediaType mediaType = headers.getContentType();
        HttpEntity entity = this.getHttpEntity(httpResponse);
        InputStream inputStream = body = entity != null ? entity.getContent() : null;
        if (body != null) {
            byte[] bytes = this.toBytes(entity);
            contentLength = entity.getContentLength();
            body = bytes != null ? new ByteArrayInputStream(bytes) : null;
        } else {
            contentLength = 0L;
        }
        DefaultResponse response = new DefaultResponse(httpStatus, mediaType, body, contentLength);
        response.getHeaders().putAll((Map)headers);
        return response;
    }

    private HttpEntity getHttpEntity(HttpResponse response) {
        Header contentEncodingHeader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (contentEncodingHeader = entity.getContentEncoding()) != null) {
            for (HeaderElement element : contentEncodingHeader.getElements()) {
                if (!element.getName().equalsIgnoreCase("gzip")) continue;
                return new GzipDecompressingEntity(response.getEntity());
            }
        }
        return entity;
    }

    private HttpHeaders getHeaders(HttpResponse response) {
        HttpHeaders headers = new HttpHeaders();
        Header[] httpHeaders = response.getAllHeaders();
        if (httpHeaders != null) {
            for (Header httpHeader : httpHeaders) {
                headers.add(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return headers;
    }

    private int getRequestExecutorParam(String key, String warning, int defaultValue) {
        Integer configuredValue = this.requestExecutorParams.get(key);
        if (configuredValue != null) {
            return configuredValue;
        }
        log.warn("Failed to read configuration property [{}: {}]. Falling back to default value: {}", new Object[]{key, warning, defaultValue});
        return defaultValue;
    }

    int getMaxConnectionPerRoute() {
        return this.getRequestExecutorParam("maxConnectionsPerRoute", "Bad max connection per route value", 0x3FFFFFFF);
    }

    int getMaxConnectionTotal() {
        return this.getRequestExecutorParam("maxConnectionsTotal", "Bad max connection total value", Integer.MAX_VALUE);
    }

    int getMaxConnectionInactivity() {
        return this.getRequestExecutorParam("validateAfterInactivity", "Invalid max connection inactivity validation value", 2000);
    }

    int getConnectionTimeToLive() {
        return this.getRequestExecutorParam("connectionTimeToLive", "Invalid connection time to live value", 300000);
    }

    private void parseRequestExecutorParams(Map<String, String> props) {
        Integer timeToLive;
        Integer validateAfterInactivity;
        Integer maxTotal;
        Integer maxPerRoute = this.lookupConfigValue(props, "maxConnectionsPerRoute", MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY);
        if (maxPerRoute != null) {
            this.requestExecutorParams.put("maxConnectionsPerRoute", maxPerRoute);
        }
        if ((maxTotal = this.lookupConfigValue(props, "maxConnectionsTotal", MAX_CONNECTIONS_TOTAL_PROPERTY_KEY)) != null) {
            this.requestExecutorParams.put("maxConnectionsTotal", maxTotal);
        }
        if ((validateAfterInactivity = this.lookupConfigValue(props, "validateAfterInactivity", CONNECTION_VALIDATION_PROPERTY_KEY)) != null) {
            this.requestExecutorParams.put("validateAfterInactivity", validateAfterInactivity);
        }
        if ((timeToLive = this.lookupConfigValue(props, "connectionTimeToLive", CONNECTION_TIME_TO_LIVE_PROPERTY_KEY)) != null) {
            this.requestExecutorParams.put("connectionTimeToLive", timeToLive);
        }
    }

    private Integer lookupConfigValue(Map<String, String> props, String key, String sysPropName) {
        try {
            String configuredValue = props.get(key);
            return Integer.parseInt(configuredValue);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse configuration property [{}]", (Object)key);
            try {
                String configuredValue = System.getProperty(sysPropName);
                return Integer.parseInt(configuredValue);
            }
            catch (NumberFormatException | SecurityException e2) {
                log.warn("Failed to parse system property [{}]", (Object)sysPropName);
                return null;
            }
        }
    }
}

