/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http.okhttp;

import com.okta.commons.http.DefaultResponse;
import com.okta.commons.http.HttpException;
import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.HttpMethod;
import com.okta.commons.http.MediaType;
import com.okta.commons.http.Request;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.RequestUtils;
import com.okta.commons.http.Response;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.lang.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class OkHttpRequestExecutor
implements RequestExecutor {
    private final OkHttpClient client;
    private final RequestAuthenticator requestAuthenticator;

    public OkHttpRequestExecutor(HttpClientConfiguration httpClientConfiguration) {
        this(httpClientConfiguration, OkHttpRequestExecutor.createOkHttpClient(httpClientConfiguration));
    }

    OkHttpRequestExecutor(HttpClientConfiguration httpClientConfiguration, OkHttpClient okHttpClient) {
        this.requestAuthenticator = httpClientConfiguration.getRequestAuthenticator();
        if (httpClientConfiguration.getRequestExecutorParams().containsKey("debug")) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            switch (((String)httpClientConfiguration.getRequestExecutorParams().get("debug")).toUpperCase()) {
                case "BODY": {
                    loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                    break;
                }
                case "HEADERS": {
                    loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                    break;
                }
                default: {
                    loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
                }
            }
            OkHttpClient.Builder clientBuilder = okHttpClient.newBuilder();
            clientBuilder.networkInterceptors().add(0, loggingInterceptor);
            this.client = clientBuilder.build();
        } else {
            this.client = okHttpClient;
        }
    }

    private static OkHttpClient createOkHttpClient(HttpClientConfiguration httpClientConfiguration) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        return OkHttpRequestExecutor.configureOkHttpClient(httpClientConfiguration, clientBuilder);
    }

    static OkHttpClient configureOkHttpClient(HttpClientConfiguration httpClientConfiguration, OkHttpClient.Builder clientBuilder) {
        clientBuilder.connectTimeout((long)httpClientConfiguration.getConnectionTimeout(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)httpClientConfiguration.getConnectionTimeout(), TimeUnit.SECONDS);
        clientBuilder.writeTimeout((long)httpClientConfiguration.getConnectionTimeout(), TimeUnit.SECONDS);
        clientBuilder.cookieJar(CookieJar.NO_COOKIES);
        clientBuilder.retryOnConnectionFailure(true);
        Proxy sdkProxy = httpClientConfiguration.getProxy();
        if (sdkProxy != null) {
            java.net.Proxy proxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(sdkProxy.getHost(), sdkProxy.getPort()));
            clientBuilder.proxy(proxy);
            if (sdkProxy.isAuthenticationRequired()) {
                clientBuilder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)sdkProxy.getUsername(), (String)sdkProxy.getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        return clientBuilder.build();
    }

    public Response executeRequest(Request request) throws HttpException {
        this.requestAuthenticator.authenticate(request);
        HttpUrl.Builder urlBuilder = HttpUrl.get((URI)request.getResourceUrl()).newBuilder();
        request.getQueryString().forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        Request.Builder okRequestBuilder = new Request.Builder().url(urlBuilder.build());
        request.getHeaders().toSingleValueMap().forEach((arg_0, arg_1) -> ((Request.Builder)okRequestBuilder).addHeader(arg_0, arg_1));
        boolean isMultipartFormDataForFileUploading = false;
        String xContentType = RequestUtils.fetchHeaderValueAndRemoveIfPresent((Request)request, (String)"x-contentType");
        if (!Strings.isEmpty((Object)xContentType)) {
            isMultipartFormDataForFileUploading = xContentType.equals("multipart/form-data");
        }
        HttpMethod method = request.getMethod();
        switch (method) {
            case DELETE: {
                okRequestBuilder.delete();
                break;
            }
            case GET: {
                okRequestBuilder.get();
                break;
            }
            case HEAD: {
                okRequestBuilder.head();
                break;
            }
            case POST: {
                if (isMultipartFormDataForFileUploading) {
                    String fileLocation = RequestUtils.fetchHeaderValueAndRemoveIfPresent((Request)request, (String)"x-fileLocation");
                    String formDataPartName = RequestUtils.fetchHeaderValueAndRemoveIfPresent((Request)request, (String)"x-fileFormDataName");
                    File file = new File(fileLocation);
                    MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(formDataPartName, file.getName(), RequestBody.create(null, (File)file)).build();
                    okRequestBuilder.post((RequestBody)requestBody);
                    break;
                }
                okRequestBuilder.post((RequestBody)new InputStreamRequestBody(request.getBody(), request.getHeaders().getContentType()));
                break;
            }
            case PUT: {
                okRequestBuilder.put((RequestBody)new InputStreamRequestBody(request.getBody(), request.getHeaders().getContentType()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HttpMethod: " + method);
            }
        }
        try {
            okhttp3.Response okResponse = this.client.newCall(okRequestBuilder.build()).execute();
            return this.toSdkResponse(okResponse);
        }
        catch (SocketException | SocketTimeoutException e) {
            throw new HttpException("Unable to execute HTTP request - retryable exception: " + e.getMessage(), (Throwable)e, true);
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    private Response toSdkResponse(okhttp3.Response okResponse) throws IOException {
        long contentLength;
        int httpStatus = okResponse.code();
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(okResponse.headers().toMultimap());
        MediaType mediaType = headers.getContentType();
        ResponseBody body = okResponse.body();
        ByteArrayInputStream bodyInputStream = null;
        if (body != null) {
            contentLength = body.contentLength();
            bodyInputStream = new ByteArrayInputStream(body.bytes());
        } else {
            contentLength = 0L;
        }
        DefaultResponse response = new DefaultResponse(httpStatus, mediaType, (InputStream)bodyInputStream, contentLength);
        response.getHeaders().putAll((Map)headers);
        return response;
    }

    private static class InputStreamRequestBody
    extends RequestBody {
        private final InputStream inputStream;
        private final okhttp3.MediaType okContentType;
        private final BufferedSource bufferedSource;

        private InputStreamRequestBody(InputStream inputStream, MediaType contentType) {
            this.inputStream = inputStream;
            this.okContentType = okhttp3.MediaType.parse((String)contentType.toString());
            this.bufferedSource = inputStream == null ? new Buffer() : Okio.buffer((Source)Okio.source((InputStream)inputStream));
        }

        public okhttp3.MediaType contentType() {
            return this.okContentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try {
                sink.writeAll((Source)this.bufferedSource.peek());
            }
            finally {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (RuntimeException rethrown) {
                        throw rethrown;
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public long contentLength() throws IOException {
            return this.inputStream != null ? (long)this.bufferedSource.peek().readByteArray().length : super.contentLength();
        }
    }
}

