/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.okta.commons.http.Response;
import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.client.Authenticator;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.client.ProceedContext;
import com.okta.idx.sdk.api.client.WrapperUtil;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.AuthenticationStatus;
import com.okta.idx.sdk.api.model.CurrentAuthenticatorEnrollment;
import com.okta.idx.sdk.api.model.CurrentAuthenticatorEnrollmentValue;
import com.okta.idx.sdk.api.model.EmailTokenType;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.model.Idp;
import com.okta.idx.sdk.api.model.Options;
import com.okta.idx.sdk.api.model.OptionsForm;
import com.okta.idx.sdk.api.model.PollInfo;
import com.okta.idx.sdk.api.model.RemediationOption;
import com.okta.idx.sdk.api.model.RequestContext;
import com.okta.idx.sdk.api.model.SecurityQuestion;
import com.okta.idx.sdk.api.response.AuthenticationResponse;
import com.okta.idx.sdk.api.response.IDXResponse;
import com.okta.idx.sdk.api.response.TokenResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthenticationTransaction {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationTransaction.class);
    private final IDXClient client;
    private final IDXClientContext clientContext;
    private final IDXResponse idxResponse;

    static AuthenticationTransaction create(IDXClient client) throws ProcessingException {
        return AuthenticationTransaction.create(client, null, null, null);
    }

    static AuthenticationTransaction create(IDXClient client, RequestContext requestContext) throws ProcessingException {
        return AuthenticationTransaction.create(client, null, null, requestContext);
    }

    AuthenticationTransaction(IDXClient client, IDXClientContext clientContext, IDXResponse idxResponse) {
        this.client = client;
        this.clientContext = clientContext;
        this.idxResponse = idxResponse;
    }

    static AuthenticationTransaction create(IDXClient client, String token, EmailTokenType tokenType, RequestContext requestContext) throws ProcessingException {
        IDXClientContext idxClientContext = client.interact(token, tokenType, requestContext);
        Assert.notNull((Object)idxClientContext, (String)"IDX client context may not be null");
        IDXResponse introspectResponse = client.introspect(idxClientContext);
        String stateHandle = introspectResponse.getStateHandle();
        Assert.hasText((String)stateHandle, (String)"State handle may not be null");
        WrapperUtil.printRemediationOptions(introspectResponse);
        return new AuthenticationTransaction(client, idxClientContext, introspectResponse);
    }

    static AuthenticationTransaction introspect(IDXClient client, IDXClientContext clientContext) throws ProcessingException {
        IDXResponse introspectResponse = client.introspect(clientContext);
        WrapperUtil.printRemediationOptions(introspectResponse);
        return new AuthenticationTransaction(client, clientContext, introspectResponse);
    }

    static AuthenticationTransaction proceed(IDXClient client, ProceedContext proceedContext, Factory factory) throws ProcessingException {
        IDXResponse idxResponse = factory.create();
        WrapperUtil.printRemediationOptions(idxResponse);
        WrapperUtil.printMessage(idxResponse);
        return new AuthenticationTransaction(client, proceedContext.getClientContext(), idxResponse);
    }

    static Response verifyEmailToken(IDXClient client, String token) throws ProcessingException {
        return client.verifyEmailToken(token);
    }

    String getStateHandle() {
        return this.idxResponse.getStateHandle();
    }

    IDXResponse getResponse() {
        return this.idxResponse;
    }

    ProceedContext createProceedContext() {
        if (this.idxResponse == null || this.idxResponse.remediation() == null || this.idxResponse.remediation().remediationOptions() == null) {
            return null;
        }
        RemediationOption[] remediationOptions = this.idxResponse.remediation().remediationOptions();
        String href = remediationOptions[0].getHref();
        String refresh = remediationOptions[0].getRefresh();
        String skipHref = null;
        Optional<RemediationOption> skipOptional = this.getOptionalRemediationOption("skip");
        if (skipOptional.isPresent()) {
            skipHref = skipOptional.get().getHref();
        }
        boolean isIdentifyInOneStep = this.isRemediationRequireCredentials("identify");
        String selectProfileEnrollHref = null;
        Optional<RemediationOption> selectEnrollProfileRemediationOption = this.getOptionalRemediationOption("select-enroll-profile");
        if (selectEnrollProfileRemediationOption.isPresent()) {
            selectProfileEnrollHref = selectEnrollProfileRemediationOption.get().getHref();
        }
        String resendHref = null;
        PollInfo pollInfo = null;
        if (this.idxResponse.getCurrentAuthenticatorEnrollment() != null && this.idxResponse.getCurrentAuthenticatorEnrollment().getValue() != null) {
            if (this.idxResponse.getCurrentAuthenticatorEnrollment().getValue().getResend() != null) {
                resendHref = this.idxResponse.getCurrentAuthenticatorEnrollment().getValue().getResend().getHref();
            }
            if (this.idxResponse.getCurrentAuthenticatorEnrollment().getValue().getPoll() != null) {
                RemediationOption pollRemediationOption = this.idxResponse.getCurrentAuthenticatorEnrollment().getValue().getPoll();
                pollInfo = new PollInfo(pollRemediationOption.getHref(), Duration.ofMillis(Long.parseLong(pollRemediationOption.getRefresh())));
            }
        } else if (this.idxResponse.getCurrentAuthenticator() != null && this.idxResponse.getCurrentAuthenticator().getValue() != null) {
            if (this.idxResponse.getCurrentAuthenticator().getValue().getResend() != null) {
                resendHref = this.idxResponse.getCurrentAuthenticator().getValue().getResend().getHref();
            }
            if (this.idxResponse.getCurrentAuthenticator().getValue().getPoll() != null) {
                RemediationOption pollRemediationOption = this.idxResponse.getCurrentAuthenticator().getValue().getPoll();
                pollInfo = new PollInfo(pollRemediationOption.getHref(), Duration.ofMillis(Long.parseLong(pollRemediationOption.getRefresh())));
            }
        }
        return new ProceedContext(this.clientContext, this.getStateHandle(), href, skipHref, isIdentifyInOneStep, selectProfileEnrollHref, resendHref, pollInfo, refresh);
    }

    RemediationOption getRemediationOption(String name) {
        Optional<RemediationOption> remediationOptionsOptional = this.getOptionalRemediationOption(name);
        Assert.isTrue((boolean)remediationOptionsOptional.isPresent(), (String)("Missing remediation option " + name));
        return remediationOptionsOptional.get();
    }

    Optional<RemediationOption> getOptionalRemediationOption(String name) {
        if (this.idxResponse == null || this.idxResponse.remediation() == null) {
            return Optional.empty();
        }
        return Arrays.stream(this.idxResponse.remediation().remediationOptions()).filter(x -> name.equals(x.getName())).findFirst();
    }

    AuthenticationTransaction proceed(Factory factory) throws ProcessingException {
        IDXResponse idxResponse = factory.create();
        WrapperUtil.printRemediationOptions(idxResponse);
        WrapperUtil.printMessage(idxResponse);
        return new AuthenticationTransaction(this.client, this.clientContext, idxResponse);
    }

    AuthenticationResponse asAuthenticationResponse() throws ProcessingException {
        return this.asAuthenticationResponse(AuthenticationStatus.UNKNOWN);
    }

    AuthenticationResponse asAuthenticationResponse(AuthenticationStatus defaultStatus) throws ProcessingException {
        AuthenticationResponse authenticationResponse = new AuthenticationResponse();
        authenticationResponse.setProceedContext(this.createProceedContext());
        AuthenticationTransaction.copyErrorMessages(this.idxResponse, authenticationResponse);
        this.fillOutIdps(authenticationResponse);
        this.fillOutAuthenticators(authenticationResponse);
        if (this.idxResponse == null) {
            return authenticationResponse;
        }
        if (this.idxResponse.isLoginSuccessful()) {
            logger.info("Login Successful!");
            TokenResponse tokenResponse = this.idxResponse.getSuccessWithInteractionCode().exchangeCode(this.client, this.clientContext);
            authenticationResponse.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
            authenticationResponse.setTokenResponse(tokenResponse);
            return authenticationResponse;
        }
        if (this.idxResponse.getCurrentAuthenticator() != null) {
            authenticationResponse.getWebAuthnParams().setCurrentAuthenticator(this.idxResponse.getCurrentAuthenticator());
        }
        if (this.idxResponse.getCurrentAuthenticatorEnrollment() != null) {
            authenticationResponse.setCurrentAuthenticatorEnrollment(this.idxResponse.getCurrentAuthenticatorEnrollment());
        }
        if (this.idxResponse.getAuthenticatorEnrollments() != null) {
            authenticationResponse.setAuthenticatorEnrollments(this.idxResponse.getAuthenticatorEnrollments());
        }
        if (this.idxResponse.getUser() != null) {
            authenticationResponse.setUser(this.idxResponse.getUser());
        }
        String firstRemediation = "";
        if (this.idxResponse.remediation() != null && this.idxResponse.remediation().remediationOptions().length > 0) {
            firstRemediation = this.idxResponse.remediation().remediationOptions()[0].getName();
        }
        switch (firstRemediation) {
            case "reenroll-authenticator": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.PASSWORD_EXPIRED);
                break;
            }
            case "authenticator-verification-data": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_VERIFICATION_DATA);
                break;
            }
            case "authenticator-enrollment-data": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_ENROLLMENT_DATA);
                break;
            }
            case "challenge-authenticator": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_VERIFICATION);
                break;
            }
            case "select-authenticator-authenticate": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_SELECTION);
                break;
            }
            case "select-authenticator-enroll": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_ENROLLMENT_SELECTION);
                break;
            }
            case "enroll-profile": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_PROFILE_ENROLLMENT);
                break;
            }
            case "enroll-authenticator": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_AUTHENTICATOR_ENROLLMENT);
                break;
            }
            case "enroll-poll": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_POLL_ENROLLMENT);
                break;
            }
            case "enrollment-channel-data": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_CHANNEL_DATA_ENROLLMENT);
                break;
            }
            case "challenge-poll": {
                authenticationResponse.setAuthenticationStatus(AuthenticationStatus.AWAITING_CHALLENGE_POLL);
                break;
            }
            default: {
                authenticationResponse.setAuthenticationStatus(defaultStatus);
            }
        }
        Optional.ofNullable(this.idxResponse.getCurrentAuthenticator()).map(CurrentAuthenticatorEnrollment::getValue).map(CurrentAuthenticatorEnrollmentValue::getContextualData).ifPresent(authenticationResponse::setContextualData);
        return authenticationResponse;
    }

    boolean isRemediationRequireCredentials(String name) {
        if (this.idxResponse.remediation() == null) {
            return false;
        }
        Optional<RemediationOption> remediationOptionOptional = this.getOptionalRemediationOption(name);
        if (!remediationOptionOptional.isPresent()) {
            return false;
        }
        FormValue[] formValues = remediationOptionOptional.get().form();
        Optional<FormValue> credentialsFormValueOptional = Arrays.stream(formValues).filter(x -> "credentials".equals(x.getName())).findFirst();
        return credentialsFormValueOptional.isPresent();
    }

    private static void copyErrorMessages(IDXResponse idxResponse, AuthenticationResponse authenticationResponse) {
        if (idxResponse == null || idxResponse.getMessages() == null) {
            return;
        }
        Arrays.stream(idxResponse.getMessages().getValue()).forEach(msg -> authenticationResponse.addError(msg.getMessage()));
    }

    private void fillOutAuthenticators(AuthenticationResponse authenticationResponse) {
        if (this.idxResponse == null || this.idxResponse.remediation() == null) {
            return;
        }
        RemediationOption[] remediationOptions = this.idxResponse.remediation().remediationOptions();
        if (remediationOptions.length > 0) {
            this.fillOutAuthenticators(remediationOptions[0], authenticationResponse);
        }
    }

    private void fillOutIdps(AuthenticationResponse authenticationResponse) {
        if (this.idxResponse == null || this.idxResponse.remediation() == null) {
            return;
        }
        LinkedList<Idp> idpList = new LinkedList<Idp>();
        RemediationOption[] remediationOptions = this.getResponse().remediation().remediationOptions();
        List remediationOptionList = Arrays.stream(remediationOptions).filter(x -> "redirect-idps".equals(x.getName()) || "redirect-idp".equals(x.getName())).collect(Collectors.toList());
        for (RemediationOption remediationOption : remediationOptionList) {
            idpList.add(new Idp(remediationOption.getType(), remediationOption.getHref()));
        }
        authenticationResponse.setIdps(idpList);
    }

    private void fillOutAuthenticators(RemediationOption remediationOption, AuthenticationResponse authenticationResponse) {
        FormValue[] formValues;
        if (remediationOption != null && (formValues = remediationOption.form()) != null) {
            Optional<FormValue> formValueOptional = Arrays.stream(formValues).filter(x -> "authenticator".equals(x.getName())).findFirst();
            if (formValueOptional.isPresent()) {
                Options[] options = formValueOptional.get().options();
                List<Authenticator> authenticators = this.getAuthenticators(options);
                if (authenticators == null) {
                    authenticators = this.getAuthenticators(formValueOptional.get());
                }
                authenticationResponse.setAuthenticators(authenticators);
            } else {
                List<SecurityQuestion> securityQuestions;
                boolean isSecQnAuth;
                Options[] options;
                formValueOptional = Arrays.stream(formValues).filter(x -> "credentials".equals(x.getName())).findFirst();
                if (formValueOptional.isPresent() && (options = formValueOptional.get().options()) != null && (isSecQnAuth = Arrays.stream(options).anyMatch(x -> "Choose a security question".equals(x.getLabel()))) && (securityQuestions = this.getSecurityQuestions(options)) != null) {
                    authenticationResponse.setSecurityQuestions(securityQuestions);
                }
            }
        }
    }

    private List<SecurityQuestion> getSecurityQuestions(Options[] options) {
        if (options == null || options.length == 0) {
            return null;
        }
        ArrayList<SecurityQuestion> securityQuestions = new ArrayList<SecurityQuestion>();
        for (Options option : options) {
            FormValue[] optionFormValues;
            for (FormValue formValue : optionFormValues = ((OptionsForm)option.getValue()).getForm().getValue()) {
                if (formValue.options() == null) continue;
                Arrays.stream(formValue.options()).forEach(e -> securityQuestions.add(new SecurityQuestion(e.getLabel(), String.valueOf(e.getValue()))));
            }
        }
        return securityQuestions;
    }

    private List<Authenticator> getAuthenticators(Options[] options) {
        if (options == null || options.length == 0) {
            return null;
        }
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        for (Options option : options) {
            FormValue[] optionFormValues;
            String id = null;
            String label = option.getLabel();
            String enrollmentId = null;
            String authenticatorType = null;
            boolean hasNestedFactors = false;
            boolean isChannelFactor = false;
            LinkedHashMap<String, String> nestedMethods = new LinkedHashMap<String, String>();
            for (FormValue formValue : optionFormValues = ((OptionsForm)option.getValue()).getForm().getValue()) {
                Options[] nestedOptions;
                if (formValue.getName().equals("methodType")) {
                    authenticatorType = String.valueOf(formValue.getValue());
                    nestedOptions = formValue.options();
                    if (nestedOptions.length > 0) {
                        for (Options children : nestedOptions) {
                            nestedMethods.put(String.valueOf(children.getValue()), String.valueOf(children.getLabel()));
                            authenticatorType = String.valueOf(option.getLabel()).toLowerCase(Locale.ROOT);
                        }
                        hasNestedFactors = true;
                    } else {
                        nestedMethods.put(String.valueOf(formValue.getValue()), label);
                    }
                } else if ("channel".equals(formValue.getName())) {
                    authenticatorType = String.valueOf(option.getLabel()).toLowerCase(Locale.ROOT).replaceAll(" ", "_");
                    isChannelFactor = true;
                    nestedOptions = formValue.options();
                    if (nestedOptions.length > 0) {
                        for (Options children : nestedOptions) {
                            nestedMethods.put(String.valueOf(children.getValue()), String.valueOf(children.getLabel()));
                        }
                        hasNestedFactors = true;
                    } else {
                        nestedMethods.put(authenticatorType, label);
                    }
                }
                if (formValue.getName().equals("id")) {
                    id = String.valueOf(formValue.getValue());
                }
                if (!formValue.getName().equals("enrollmentId")) continue;
                enrollmentId = String.valueOf(formValue.getValue());
            }
            ArrayList<Authenticator.Factor> factors = new ArrayList<Authenticator.Factor>();
            for (Map.Entry entry : nestedMethods.entrySet()) {
                factors.add(new Authenticator.Factor(id, (String)entry.getKey(), enrollmentId, (String)entry.getValue(), isChannelFactor ? (String)entry.getKey() : null));
            }
            authenticators.add(new Authenticator(id, authenticatorType, label, factors, hasNestedFactors));
        }
        return authenticators;
    }

    private List<Authenticator> getAuthenticators(FormValue parent) {
        if (parent == null) {
            return null;
        }
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        String id = null;
        String label = parent.getLabel();
        String enrollmentId = null;
        String authenticatorType = null;
        LinkedHashMap<String, String> nestedMethods = new LinkedHashMap<String, String>();
        boolean hasNestedFactors = false;
        for (FormValue formValue : parent.form().getValue()) {
            if (formValue.getName().equals("methodType")) {
                authenticatorType = String.valueOf(formValue.getValue());
                Options[] nestedOptions = formValue.options();
                if (nestedOptions.length > 0) {
                    for (Options children : nestedOptions) {
                        nestedMethods.put(String.valueOf(children.getValue()), String.valueOf(children.getLabel()));
                    }
                    hasNestedFactors = true;
                } else {
                    nestedMethods.put(String.valueOf(formValue.getValue()), label);
                }
            }
            if (formValue.getName().equals("id")) {
                id = String.valueOf(formValue.getValue());
            }
            if (!formValue.getName().equals("enrollmentId")) continue;
            enrollmentId = String.valueOf(formValue.getValue());
        }
        ArrayList<Authenticator.Factor> factors = new ArrayList<Authenticator.Factor>();
        for (Map.Entry entry : nestedMethods.entrySet()) {
            factors.add(new Authenticator.Factor(id, (String)entry.getKey(), enrollmentId, (String)entry.getValue(), null));
        }
        authenticators.add(new Authenticator(id, authenticatorType, label, factors, hasNestedFactors));
        return authenticators;
    }

    static interface Factory {
        public IDXResponse create() throws ProcessingException;
    }
}

