/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.idx.sdk.api.client.BaseIDXClient;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.client.IDXClientBuilder;
import com.okta.idx.sdk.api.config.ClientConfiguration;
import com.okta.idx.sdk.api.config.EnvironmentVariablesPropertiesSource;
import com.okta.idx.sdk.api.config.OptionalPropertiesSource;
import com.okta.idx.sdk.api.config.PropertiesSource;
import com.okta.idx.sdk.api.config.ResourcePropertiesSource;
import com.okta.idx.sdk.api.config.SystemPropertiesSource;
import com.okta.idx.sdk.api.config.YAMLPropertiesSource;
import com.okta.idx.sdk.api.io.DefaultResourceFactory;
import com.okta.idx.sdk.api.io.Resource;
import com.okta.idx.sdk.api.io.ResourceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class DefaultIDXClientBuilder
extends IDXClientBuilder {
    private static final String ENVVARS_TOKEN = "envvars";
    private static final String SYSPROPS_TOKEN = "sysprops";
    private static final String OKTA_CONFIG_CP = "com/okta/sdk/config/";
    private static final String OKTA_YAML = "okta.yaml";
    private static final String OKTA_PROPERTIES = "okta.properties";
    private boolean allowNonHttpsForTesting = false;
    private final ClientConfiguration clientConfig = new ClientConfiguration();

    public DefaultIDXClientBuilder() {
        this(new DefaultResourceFactory());
    }

    DefaultIDXClientBuilder(ResourceFactory resourceFactory) {
        ArrayList<PropertiesSource> sources = new ArrayList<PropertiesSource>();
        for (String location : DefaultIDXClientBuilder.configSources()) {
            if (ENVVARS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(EnvironmentVariablesPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            if (SYSPROPS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(SystemPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            Resource resource = resourceFactory.createResource(location);
            PropertiesSource wrappedSource = Strings.endsWithIgnoreCase((String)location, (String)".yaml") ? new YAMLPropertiesSource(resource) : new ResourcePropertiesSource(resource);
            OptionalPropertiesSource propertiesSource = new OptionalPropertiesSource(wrappedSource);
            sources.add(propertiesSource);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (PropertiesSource source : sources) {
            Map<String, String> srcProps = source.getProperties();
            props.putAll(srcProps);
        }
        if (Strings.hasText((String)((String)props.get("okta.idx.issuer")))) {
            this.clientConfig.setIssuer((String)props.get("okta.idx.issuer"));
        }
        if (Strings.hasText((String)((String)props.get("okta.idx.clientId")))) {
            this.clientConfig.setClientId((String)props.get("okta.idx.clientId"));
        }
        if (Strings.hasText((String)((String)props.get("okta.idx.clientSecret")))) {
            this.clientConfig.setClientSecret((String)props.get("okta.idx.clientSecret"));
        }
        if (Strings.hasText((String)((String)props.get("okta.idx.scopes")))) {
            HashSet<String> scopes = new HashSet<String>(Arrays.asList(((String)props.get("okta.idx.scopes")).split("[\\s,]+")));
            this.clientConfig.setScopes(scopes);
        }
        if (Strings.hasText((String)((String)props.get("okta.idx.redirectUri")))) {
            this.clientConfig.setRedirectUri((String)props.get("okta.idx.redirectUri"));
        }
        if (Strings.hasText((String)((String)props.get("okta.testing.disableHttpsCheck")))) {
            this.allowNonHttpsForTesting = Boolean.parseBoolean((String)props.get("okta.testing.disableHttpsCheck"));
        }
    }

    @Override
    public IDXClientBuilder setIssuer(String issuer) {
        this.clientConfig.setIssuer(issuer);
        return this;
    }

    @Override
    public IDXClientBuilder setClientId(String clientId) {
        this.clientConfig.setClientId(clientId);
        return this;
    }

    @Override
    public IDXClientBuilder setClientSecret(String clientSecret) {
        this.clientConfig.setClientSecret(clientSecret);
        return this;
    }

    @Override
    public IDXClientBuilder setScopes(Set<String> scopes) {
        this.clientConfig.setScopes(scopes);
        return this;
    }

    @Override
    public IDXClientBuilder setRedirectUri(String redirectUri) {
        this.clientConfig.setRedirectUri(redirectUri);
        return this;
    }

    @Override
    public IDXClient build() {
        this.validate();
        return new BaseIDXClient(this.clientConfig, null);
    }

    private void validate() throws IllegalArgumentException {
        ConfigurationValidator.assertOrgUrl((String)this.clientConfig.getIssuer(), (boolean)this.allowNonHttpsForTesting);
        ConfigurationValidator.assertClientId((String)this.clientConfig.getClientId());
        Assert.isTrue((!Collections.isEmpty(this.clientConfig.getScopes()) ? 1 : 0) != 0, (String)"At least one scope is required");
        Assert.hasText((String)this.clientConfig.getRedirectUri(), (String)"redirectUri is required");
    }

    private static String[] configSources() {
        return new String[]{"classpath:com/okta/sdk/config/okta.properties", "classpath:com/okta/sdk/config/okta.yaml", "classpath:okta.properties", "classpath:okta.yaml", System.getProperty("user.home") + File.separatorChar + ".okta" + File.separatorChar + OKTA_YAML, ENVVARS_TOKEN, SYSPROPS_TOKEN};
    }
}

