/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.io;

import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.io.ClasspathResource;
import com.okta.idx.sdk.api.io.FileResource;
import com.okta.idx.sdk.api.io.Resource;
import com.okta.idx.sdk.api.io.ResourceFactory;
import com.okta.idx.sdk.api.io.UrlResource;
import java.util.Locale;

public class DefaultResourceFactory
implements ResourceFactory {
    @Override
    public Resource createResource(String location) {
        Assert.hasText((String)location, (String)"location argument cannot be null or empty.");
        if (location.startsWith("classpath:")) {
            return new ClasspathResource(location);
        }
        String lcase = location.toLowerCase(Locale.ENGLISH);
        if (location.startsWith("url:") || lcase.startsWith("http:") || lcase.startsWith("https:")) {
            return new UrlResource(location);
        }
        return new FileResource(location);
    }
}

