/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.io;

import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.io.Resource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class StringResource
implements Resource {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String string;
    private final Charset charset;

    public StringResource(String s) {
        this(s, UTF_8);
    }

    public StringResource(String string, Charset charset) {
        Assert.hasText((String)string, (String)"String argument cannot be null or empty.");
        Assert.notNull((Object)charset, (String)"Charset argument cannot be null or empty.");
        this.string = string;
        this.charset = charset;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.string.getBytes(this.charset));
    }
}

