/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.Options;
import com.okta.idx.sdk.api.model.OptionsForm;
import com.okta.idx.sdk.api.request.AnswerChallengeRequest;
import com.okta.idx.sdk.api.request.ChallengeRequest;
import com.okta.idx.sdk.api.request.EnrollRequest;
import com.okta.idx.sdk.api.request.EnrollUserProfileUpdateRequest;
import com.okta.idx.sdk.api.request.IdentifyRequest;
import com.okta.idx.sdk.api.request.SkipAuthenticatorEnrollmentRequest;
import com.okta.idx.sdk.api.response.IDXResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RemediationOption {
    private String[] rel;
    private String name;
    private String type;
    private String method;
    private String href;
    private FormValue[] value;
    private String accepts;
    private String refresh;

    public IDXResponse proceed(IDXClient client, Object request) throws IllegalStateException, IllegalArgumentException, ProcessingException {
        Assert.notNull((Object)request, (String)"request cannot be null");
        if (request instanceof IdentifyRequest) {
            return client.identify((IdentifyRequest)request, this.href);
        }
        if (request instanceof ChallengeRequest) {
            return client.challenge((ChallengeRequest)request, this.href);
        }
        if (request instanceof AnswerChallengeRequest) {
            return client.answerChallenge((AnswerChallengeRequest)request, this.href);
        }
        if (request instanceof EnrollRequest) {
            return client.enroll((EnrollRequest)request, this.href);
        }
        if (request instanceof EnrollUserProfileUpdateRequest) {
            return client.enrollUpdateUserProfile((EnrollUserProfileUpdateRequest)request, this.href);
        }
        if (request instanceof SkipAuthenticatorEnrollmentRequest) {
            return client.skip((SkipAuthenticatorEnrollmentRequest)request, this.href);
        }
        throw new IllegalStateException("Cannot invoke proceed with the supplied request type " + request.getClass().getSimpleName());
    }

    public FormValue[] form() {
        return this.value != null ? Arrays.copyOf(this.value, this.value.length) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public String getRefresh() {
        return this.refresh;
    }

    public Map<String, String> getAuthenticatorOptions() {
        HashMap<String, String> authenticatorOptionsMap = new HashMap<String, String>();
        FormValue[] formValues = this.form();
        Optional<FormValue> formValueOptional = Arrays.stream(formValues).filter(x -> "authenticator".equals(x.getName())).findFirst();
        if (formValueOptional.isPresent()) {
            Options[] options;
            for (Options option : options = formValueOptional.get().options()) {
                FormValue[] optionFormValues;
                String key = null;
                String val = null;
                for (FormValue formValue : optionFormValues = ((OptionsForm)option.getValue()).getForm().getValue()) {
                    if (formValue.getName().equals("methodType")) {
                        key = String.valueOf(formValue.getValue());
                        StringBuilder nestedKeys = new StringBuilder();
                        if (key.equals("null")) {
                            for (Options children : formValue.options()) {
                                nestedKeys.append(children.getValue());
                                nestedKeys.append(",");
                            }
                            nestedKeys = nestedKeys.deleteCharAt(nestedKeys.length() - 1);
                            key = nestedKeys.toString();
                        }
                    }
                    if (formValue.getName().equals("id")) {
                        val = String.valueOf(formValue.getValue());
                    }
                    if (!formValue.getName().equals("enrollmentId")) continue;
                    authenticatorOptionsMap.put("enrollmentId", String.valueOf(formValue.getValue()));
                }
                if (key == null) continue;
                String[] tokenizedKey = key.split(",");
                if (tokenizedKey != null) {
                    for (String tmpKey : tokenizedKey) {
                        authenticatorOptionsMap.put(tmpKey, val);
                    }
                    continue;
                }
                authenticatorOptionsMap.put(key, val);
            }
        }
        return authenticatorOptionsMap;
    }
}

