/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.okta.commons.lang.Assert;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.response.TokenResponse;
import java.util.Arrays;
import java.util.Optional;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SuccessResponse {
    private String[] rel;
    private String name;
    private String method;
    private String href;
    private FormValue[] value;
    private String accepts;

    public String[] getRel() {
        return Arrays.copyOf(this.rel, this.rel.length);
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHref() {
        return this.href;
    }

    public FormValue[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public String getAccepts() {
        return this.accepts;
    }

    public FormValue[] form() {
        return this.getValue();
    }

    private String parseGrantType() {
        Optional<FormValue> grantTypeForm = Arrays.stream(this.value).filter(x -> "grant_type".equals(x.getName())).findAny();
        Assert.isTrue((boolean)grantTypeForm.isPresent());
        return String.valueOf(grantTypeForm.get().getValue());
    }

    private String parseInteractionCode() {
        String interactionCodeLookupKey = this.parseGrantType();
        Optional<FormValue> interactionCodeForm = Arrays.stream(this.value).filter(x -> interactionCodeLookupKey.equals(x.getName())).findAny();
        Assert.isTrue((boolean)interactionCodeForm.isPresent());
        return String.valueOf(interactionCodeForm.get().getValue());
    }

    public TokenResponse exchangeCode(IDXClient client, IDXClientContext idxClientContext) throws ProcessingException {
        String grantType = this.parseGrantType();
        String interactionCode = this.parseInteractionCode();
        String tokenUrl = this.getHref();
        return client.token(tokenUrl, grantType, interactionCode, idxClientContext);
    }
}

