/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.http.authc.DisabledAuthenticator;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.jwt.VerifierBuilderSupport;
import com.okta.jwt.impl.http.HttpClient;
import com.okta.jwt.impl.http.OktaCommonsHttpClient;
import com.okta.jwt.impl.jjwt.RemoteJwkSigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;

abstract class BaseVerifierBuilderSupport<B extends VerifierBuilderSupport, R>
implements VerifierBuilderSupport<B, R> {
    private String issuer;
    private Duration leeway = Duration.ofMinutes(2L);
    private Duration connectionTimeout = Duration.ofSeconds(1L);
    private String proxyHost = null;
    private int proxyPort;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private int retryMaxAttempts = 2;
    private Duration retryMaxElapsed = Duration.ofSeconds(10L);

    BaseVerifierBuilderSupport() {
    }

    String getIssuer() {
        return this.issuer;
    }

    public B setIssuer(String issuer) {
        if (issuer != null) {
            this.issuer = issuer.trim().replaceAll("/$", "");
        }
        return this.self();
    }

    Duration getLeeway() {
        return this.leeway;
    }

    public B setLeeway(Duration leeway) {
        if (leeway == null || leeway.toMillis() < 0L) {
            throw new IllegalArgumentException("leeway must not be null or less than zero");
        }
        this.leeway = leeway;
        return this.self();
    }

    Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public B setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this.self();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public B setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this.self();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public B setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this.self();
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public B setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this.self();
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public B setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this.self();
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public B setRetryMaxAttempts(int retryMaxAttempts) {
        this.retryMaxAttempts = retryMaxAttempts;
        return this.self();
    }

    public Duration getMaxHttpRetryElapsed() {
        return this.retryMaxElapsed;
    }

    public B setRetryMaxElapsed(Duration retryMaxElapsed) {
        this.retryMaxElapsed = retryMaxElapsed;
        return this.self();
    }

    protected B self() {
        return (B)this;
    }

    protected void validate() {
        ConfigurationValidator.assertIssuer((String)this.issuer);
    }

    protected String resolveKeysEndpoint(String issuer) {
        return issuer.matches(".*/oauth2/.*") ? issuer + "/v1/keys" : issuer + "/oauth2/v1/keys";
    }

    protected SigningKeyResolver signingKeyResolver() {
        try {
            return new RemoteJwkSigningKeyResolver(new URL(this.resolveKeysEndpoint(this.getIssuer())), this.httpClient());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid issuer URL in configuration");
        }
    }

    protected HttpClient httpClient() {
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration();
        httpClientConfiguration.setRequestAuthenticator((RequestAuthenticator)new DisabledAuthenticator());
        httpClientConfiguration.setConnectionTimeout((int)this.getConnectionTimeout().getSeconds());
        httpClientConfiguration.setRetryMaxAttempts(this.getRetryMaxAttempts());
        httpClientConfiguration.setRetryMaxElapsed((int)this.getMaxHttpRetryElapsed().getSeconds());
        httpClientConfiguration.setProxyHost(this.getProxyHost());
        httpClientConfiguration.setProxyPort(this.getProxyPort());
        httpClientConfiguration.setProxyUsername(this.getProxyUsername());
        httpClientConfiguration.setProxyPassword(this.getProxyPassword());
        return new OktaCommonsHttpClient(httpClientConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseVerifierBuilderSupport that = (BaseVerifierBuilderSupport)o;
        return this.proxyPort == that.proxyPort && this.retryMaxAttempts == that.retryMaxAttempts && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.leeway, that.leeway) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.retryMaxElapsed, that.retryMaxElapsed);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.leeway, this.connectionTimeout, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, this.retryMaxAttempts, this.retryMaxElapsed);
    }
}

