/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.commons.lang.Assert;
import com.okta.jwt.AccessTokenVerifier;
import com.okta.jwt.impl.jjwt.BaseVerifierBuilderSupport;
import com.okta.jwt.impl.jjwt.JjwtAccessTokenVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JjwtAccessTokenVerifierBuilder
extends BaseVerifierBuilderSupport<AccessTokenVerifier.Builder, AccessTokenVerifier>
implements AccessTokenVerifier.Builder {
    private static final Logger log = LoggerFactory.getLogger(JjwtAccessTokenVerifierBuilder.class);
    private String audience = "api://default";

    public AccessTokenVerifier.Builder setAudience(String audience) {
        Assert.notNull((Object)audience, (String)"audience cannot be null");
        this.audience = audience;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.audience == null || this.audience.isEmpty()) {
            throw new IllegalArgumentException("audience cannot be null or empty");
        }
        if (!this.getIssuer().matches(".*/oauth2/.*")) {
            log.warn("Decoding access tokens from this issuer '{}' may not be possible. Your issuer URL should be in the format of 'https://{yourOktaDomain}/oauth2/qualifier'", (Object)this.getIssuer());
        }
    }

    public AccessTokenVerifier build() {
        this.validate();
        return new JjwtAccessTokenVerifier(this.getIssuer(), this.audience, this.getLeeway(), this.signingKeyResolver());
    }
}

