/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.jwt.AccessTokenVerifier;
import com.okta.jwt.Jwt;
import com.okta.jwt.JwtVerificationException;
import com.okta.jwt.impl.jjwt.ClaimsValidator;
import com.okta.jwt.impl.jjwt.TokenVerifierSupport;
import io.jsonwebtoken.SigningKeyResolver;
import java.time.Clock;
import java.time.Duration;

public class JjwtAccessTokenVerifier
extends TokenVerifierSupport
implements AccessTokenVerifier {
    private final String audience;

    public JjwtAccessTokenVerifier(String issuer, String audience, Duration leeway, SigningKeyResolver signingKeyResolver) {
        super(issuer, leeway, signingKeyResolver, Clock.systemDefaultZone());
        this.audience = audience;
    }

    public JjwtAccessTokenVerifier(String issuer, String audience, Duration leeway, SigningKeyResolver signingKeyResolver, Clock clock) {
        super(issuer, leeway, signingKeyResolver, clock);
        this.audience = audience;
    }

    public Jwt decode(String accessToken) throws JwtVerificationException {
        return this.decode(accessToken, this.parser(), new ClaimsValidator.ContainsAudienceClaimsValidator(this.audience));
    }
}

