/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SimpleSecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.okta.jwt.JoseException;
import com.okta.jwt.Jwt;
import com.okta.jwt.JwtVerifier;
import com.okta.jwt.impl.Assert;
import com.okta.jwt.impl.DefaultJwt;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;

public class NimbusJwtVerifier
implements JwtVerifier {
    static final String TOKEN_TYPE_KEY = "token_type";
    static final String TOKEN_TYPE_ACCESS = "access_token";
    static final String TOKEN_TYPE_ID = "id_token";
    static final String NONCE_KEY = "nonce";
    private final ConfigurableJWTProcessor jwtProcessor;

    public NimbusJwtVerifier(ConfigurableJWTProcessor jwtProcessor) {
        Assert.notNull(jwtProcessor, "Nimbus JWT Processor cannot be empty");
        this.jwtProcessor = jwtProcessor;
    }

    @Override
    public Jwt decodeIdToken(String jwtString, String nonce) throws JoseException {
        Assert.notNull(jwtString, "JWT String cannot be null");
        SimpleSecurityContext context = new SimpleSecurityContext();
        context.put((Object)TOKEN_TYPE_KEY, (Object)TOKEN_TYPE_ID);
        context.put((Object)NONCE_KEY, (Object)nonce);
        return this.decode(jwtString, (SecurityContext)context);
    }

    @Override
    public Jwt decodeAccessToken(String jwtString) throws JoseException {
        Assert.notNull(jwtString, "JWT String cannot be null");
        SimpleSecurityContext context = new SimpleSecurityContext();
        context.put((Object)TOKEN_TYPE_KEY, (Object)TOKEN_TYPE_ACCESS);
        return this.decode(jwtString, (SecurityContext)context);
    }

    private Jwt decode(String jwtString, SecurityContext context) throws JoseException {
        try {
            JWTClaimsSet claimsSet = this.jwtProcessor.process(jwtString, context);
            return new DefaultJwt(jwtString, this.nullSafeToInstant(claimsSet.getIssueTime()), this.nullSafeToInstant(claimsSet.getExpirationTime()), claimsSet.getClaims());
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            throw new JoseException("Failed to validate JWT string", e);
        }
    }

    private Instant nullSafeToInstant(Date date) {
        return date != null ? date.toInstant() : null;
    }
}

