/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.okta.jwt.impl.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OktaJWTClaimsVerifier<C extends SecurityContext>
extends DefaultJWTClaimsVerifier<C> {
    private static final String CID_CLAIM = "cid";
    private final String issuer;
    private final String audience;
    private final String clientId;

    public OktaJWTClaimsVerifier(String issuer, String audience, String clientId) {
        this.issuer = issuer;
        this.audience = audience;
        this.clientId = clientId;
    }

    public void verify(JWTClaimsSet jwt, C context) throws BadJWTException {
        List resolvedAudience;
        Object claimIssuer;
        Assert.notNull(jwt, "JWTClaimsSet cannot be null");
        super.verify(jwt, context);
        String tokenType = "access_token";
        String nonce = null;
        if (context instanceof Map) {
            Map contextMap = (Map)context;
            Object value = contextMap.get("token_type");
            if (value != null) {
                tokenType = value.toString();
            }
            nonce = (String)contextMap.get("nonce");
        }
        if (!this.issuer.equals(claimIssuer = jwt.getClaims().get("iss"))) {
            throw new BadJWTException(String.format("Failed to validate jwt string, invalid issuer, expected '%s', found '%s'", this.issuer, claimIssuer));
        }
        if ("access_token".equals(tokenType)) {
            Object resolvedClientId;
            resolvedAudience = jwt.getAudience();
            if (CollectionUtils.isEmpty((Collection)resolvedAudience) || !resolvedAudience.contains(this.audience)) {
                throw new BadJWTException(String.format("Failed to validate jwt string, invalid audience claim 'aud', expected '%s', but found '%s'", this.audience, resolvedAudience));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.clientId) && !this.clientId.equals(resolvedClientId = jwt.getClaim(CID_CLAIM))) {
                throw new BadJWTException(String.format("Failed to validate jwt string, invalid clientId found in claim 'cid', expected '%s', but found '%s'", this.clientId, resolvedClientId));
            }
        } else if ("id_token".equals(tokenType)) {
            Assert.notNull(this.clientId, "An OAuth clientId must be specified when validating ID Tokens.");
            resolvedAudience = jwt.getAudience();
            if (CollectionUtils.isEmpty((Collection)resolvedAudience) || !resolvedAudience.contains(this.clientId)) {
                throw new BadJWTException(String.format("Failed to validate jwt string, invalid clientId found in claim 'aud', expected '%s', but found '%s'", this.clientId, resolvedAudience));
            }
            Object resolvedNonce = jwt.getClaim("nonce");
            if (nonce != null && !nonce.equals(resolvedNonce)) {
                throw new BadJWTException(String.format("Invalid nonce found in ID Token, expected '%s', but found '%s'", nonce, resolvedNonce));
            }
            String subject = jwt.getSubject();
            if (subject == null) {
                throw new BadJWTException("Invalid ID Token, missing subject claim ('sub')");
            }
        } else {
            throw new BadJWTException(String.format("Unknown token type: '%s'", tokenType));
        }
    }
}

