/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.jwt.JwtVerifier;
import com.okta.jwt.impl.NimbusJwtVerifier;
import com.okta.jwt.impl.OktaJWTClaimsVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class JwtHelper {
    private String issuerUrl;
    private String audience = "api://default";
    private String clientId;
    private int connectionTimeout = 1000;
    private int readTimeout = 1000;

    public JwtHelper setIssuerUrl(String issuerUrl) {
        String tmpUrl = issuerUrl;
        if (tmpUrl != null) {
            tmpUrl = tmpUrl.replaceAll("/$", "");
        }
        this.issuerUrl = tmpUrl;
        return this;
    }

    public JwtHelper setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public JwtHelper setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public JwtHelper setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public JwtHelper setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public JwtVerifier build() throws IOException {
        ConfigurationValidator.assertIssuer((String)this.issuerUrl);
        this.notEmpty(this.audience, "Audience cannot be empty");
        URL keysURI = URI.create(JwtHelper.resolveKeysEndpoint(this.issuerUrl)).toURL();
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        RemoteJWKSet keySource = new RemoteJWKSet(keysURI, (ResourceRetriever)new DefaultResourceRetriever(this.connectionTimeout, this.readTimeout, 51200));
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.RS256;
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        jwtProcessor.setJWTClaimsSetVerifier(new OktaJWTClaimsVerifier(this.issuerUrl, this.audience, this.clientId));
        return new NimbusJwtVerifier((ConfigurableJWTProcessor)jwtProcessor);
    }

    String readMetadataFromUrl(URL url) throws IOException {
        return IOUtils.readInputStreamToString((InputStream)url.openStream(), (Charset)StandardCharsets.UTF_8);
    }

    private void notEmpty(String value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String resolveKeysEndpoint(String issuer) {
        return issuer.matches(".*/oauth2/.*") ? issuer + "/v1/keys" : issuer + "/oauth2/v1/keys";
    }
}

