/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl;

import com.okta.jwt.Jwt;
import com.okta.jwt.impl.Assert;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultJwt
implements Jwt {
    private final String tokenValue;
    private final Map<String, Object> claims;
    private Instant issuedAt;
    private Instant expiresAt;

    public DefaultJwt(String tokenValue, Instant issuedAt, Instant expiresAt, Map<String, Object> claims) {
        Assert.notNull(tokenValue, "JWT token cannot be null");
        Assert.notNull(issuedAt, "issuedAt cannot be null");
        Assert.notNull(expiresAt, "expiresAt cannot be null");
        Assert.notEmpty(claims, "claims cannot be empty");
        this.tokenValue = tokenValue;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    @Override
    public String getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }
}

