/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.UserCredentials;
import com.okta.sdk.resource.model.UserProfile;
import com.okta.sdk.resource.model.UserType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"credentials", "groupIds", "profile", "realmId", "type"})
public class CreateUserRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private UserCredentials credentials;
    public static final String JSON_PROPERTY_GROUP_IDS = "groupIds";
    private List<String> groupIds = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserProfile profile;
    public static final String JSON_PROPERTY_REALM_ID = "realmId";
    private String realmId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private UserType type;

    public CreateUserRequest credentials(UserCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
    }

    public CreateUserRequest groupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public CreateUserRequest addGroupIdsItem(String groupIdsItem) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        this.groupIds.add(groupIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="groupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @JsonProperty(value="groupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public CreateUserRequest profile(UserProfile profile) {
        this.profile = profile;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    public CreateUserRequest realmId(String realmId) {
        this.realmId = realmId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="guo1bfiNtSnZYILxO0g4", value="The ID of the realm in which the user is residing")
    @JsonProperty(value="realmId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRealmId() {
        return this.realmId;
    }

    @JsonProperty(value="realmId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public CreateUserRequest type(UserType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(UserType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest createUserRequest = (CreateUserRequest)o;
        return Objects.equals(this.credentials, createUserRequest.credentials) && Objects.equals(this.groupIds, createUserRequest.groupIds) && Objects.equals(this.profile, createUserRequest.profile) && Objects.equals(this.realmId, createUserRequest.realmId) && Objects.equals(this.type, createUserRequest.type);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.groupIds, this.profile, this.realmId, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequest {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    realmId: ").append(this.toIndentedString(this.realmId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

