/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.NetworkZoneAddress;
import com.okta.sdk.resource.model.NetworkZoneLinks;
import com.okta.sdk.resource.model.NetworkZoneLocation;
import com.okta.sdk.resource.model.NetworkZoneStatus;
import com.okta.sdk.resource.model.NetworkZoneType;
import com.okta.sdk.resource.model.NetworkZoneUsage;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"asns", "created", "gateways", "id", "lastUpdated", "locations", "name", "proxies", "proxyType", "status", "system", "type", "usage", "_links"})
public class NetworkZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ASNS = "asns";
    private List<String> asns = null;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_GATEWAYS = "gateways";
    private List<NetworkZoneAddress> gateways = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<NetworkZoneLocation> locations = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIES = "proxies";
    private JsonNullable<List<NetworkZoneAddress>> proxies = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROXY_TYPE = "proxyType";
    private ProxyTypeEnum proxyType;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NetworkZoneStatus status;
    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system;
    public static final String JSON_PROPERTY_TYPE = "type";
    private NetworkZoneType type;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private NetworkZoneUsage usage;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private NetworkZoneLinks links;

    public NetworkZone asns(List<String> asns) {
        this.asns = asns;
        return this;
    }

    public NetworkZone addAsnsItem(String asnsItem) {
        if (this.asns == null) {
            this.asns = new ArrayList<String>();
        }
        this.asns.add(asnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dynamic network zone property. array of strings that represent an ASN numeric value")
    @JsonProperty(value="asns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAsns() {
        return this.asns;
    }

    @JsonProperty(value="asns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsns(List<String> asns) {
        this.asns = asns;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the network zone was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public NetworkZone gateways(List<NetworkZoneAddress> gateways) {
        this.gateways = gateways;
        return this;
    }

    public NetworkZone addGatewaysItem(NetworkZoneAddress gatewaysItem) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<NetworkZoneAddress>();
        }
        this.gateways.add(gatewaysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP network zone property: the IP addresses (range or CIDR form) of this zone. The maximum array length is 150 entries for admin-created IP zones, 1000 entries for IP blocklist zones, and 5000 entries for the default system IP Zone.")
    @JsonProperty(value="gateways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NetworkZoneAddress> getGateways() {
        return this.gateways;
    }

    @JsonProperty(value="gateways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGateways(List<NetworkZoneAddress> gateways) {
        this.gateways = gateways;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the network zone")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the network zone was last modified")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public NetworkZone locations(List<NetworkZoneLocation> locations) {
        this.locations = locations;
        return this;
    }

    public NetworkZone addLocationsItem(NetworkZoneLocation locationsItem) {
        if (this.locations == null) {
            this.locations = new ArrayList<NetworkZoneLocation>();
        }
        this.locations.add(locationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dynamic network zone property: an array of geolocations of this network zone")
    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NetworkZoneLocation> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocations(List<NetworkZoneLocation> locations) {
        this.locations = locations;
    }

    public NetworkZone name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique name for this network zone. Maximum of 128 characters.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public NetworkZone proxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.of(proxies);
        return this;
    }

    public NetworkZone addProxiesItem(NetworkZoneAddress proxiesItem) {
        if (this.proxies == null || !this.proxies.isPresent()) {
            this.proxies = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.proxies.get()).add(proxiesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP network zone property: the IP addresses (range or CIDR form) that are allowed to forward a request from gateway addresses These proxies are automatically trusted by Threat Insights, and used to identify the client IP of a request. The maximum array length is 150 entries for admin-created zones and 5000 entries for the default system IP Zone.")
    @JsonIgnore
    public List<NetworkZoneAddress> getProxies() {
        return (List)this.proxies.orElse(null);
    }

    @JsonProperty(value="proxies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<NetworkZoneAddress>> getProxies_JsonNullable() {
        return this.proxies;
    }

    @JsonProperty(value="proxies")
    public void setProxies_JsonNullable(JsonNullable<List<NetworkZoneAddress>> proxies) {
        this.proxies = proxies;
    }

    public void setProxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.of(proxies);
    }

    public NetworkZone proxyType(ProxyTypeEnum proxyType) {
        this.proxyType = proxyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dynamic network zone property: the proxy type used")
    @JsonProperty(value="proxyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProxyTypeEnum getProxyType() {
        return this.proxyType;
    }

    @JsonProperty(value="proxyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProxyType(ProxyTypeEnum proxyType) {
        this.proxyType = proxyType;
    }

    public NetworkZone status(NetworkZoneStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkZoneStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(NetworkZoneStatus status) {
        this.status = status;
    }

    public NetworkZone system(Boolean system) {
        this.system = system;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if this is a system network zone. For admin-created zones, this is always `false`. The system IP Policy Network Zone (`LegacyIpZone`) is included by default in your Okta org. Notice that `system=true` for the `LegacyIpZone` object. Admin users can modify the name of this default system Zone and can add up to 5000 gateway or proxy IP entries.")
    @JsonProperty(value="system")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSystem() {
        return this.system;
    }

    @JsonProperty(value="system")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSystem(Boolean system) {
        this.system = system;
    }

    public NetworkZone type(NetworkZoneType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkZoneType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(NetworkZoneType type) {
        this.type = type;
    }

    public NetworkZone usage(NetworkZoneUsage usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkZoneUsage getUsage() {
        return this.usage;
    }

    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsage(NetworkZoneUsage usage) {
        this.usage = usage;
    }

    public NetworkZone links(NetworkZoneLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkZoneLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(NetworkZoneLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkZone networkZone = (NetworkZone)o;
        return Objects.equals(this.asns, networkZone.asns) && Objects.equals(this.created, networkZone.created) && Objects.equals(this.gateways, networkZone.gateways) && Objects.equals(this.id, networkZone.id) && Objects.equals(this.lastUpdated, networkZone.lastUpdated) && Objects.equals(this.locations, networkZone.locations) && Objects.equals(this.name, networkZone.name) && NetworkZone.equalsNullable(this.proxies, networkZone.proxies) && Objects.equals((Object)this.proxyType, (Object)networkZone.proxyType) && Objects.equals((Object)this.status, (Object)networkZone.status) && Objects.equals(this.system, networkZone.system) && Objects.equals((Object)this.type, (Object)networkZone.type) && Objects.equals((Object)this.usage, (Object)networkZone.usage) && Objects.equals(this.links, networkZone.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asns, this.created, this.gateways, this.id, this.lastUpdated, this.locations, this.name, NetworkZone.hashCodeNullable(this.proxies), this.proxyType, this.status, this.system, this.type, this.usage, this.links});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkZone {\n");
        sb.append("    asns: ").append(this.toIndentedString(this.asns)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    gateways: ").append(this.toIndentedString(this.gateways)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proxies: ").append(this.toIndentedString(this.proxies)).append("\n");
        sb.append("    proxyType: ").append(this.toIndentedString((Object)this.proxyType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString((Object)this.usage)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProxyTypeEnum {
        NULL("null"),
        ANY("Any"),
        TOR("Tor"),
        NOTTORANONYMIZER("NotTorAnonymizer");

        private String value;

        private ProxyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProxyTypeEnum fromValue(String value) {
            for (ProxyTypeEnum b : ProxyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

