/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AssociatedServerMediated;
import com.okta.sdk.resource.model.AuthorizationServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerAssocApi {
    private ApiClient apiClient;

    public AuthorizationServerAssocApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerAssocApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<AuthorizationServer> createAssociatedServers(String authServerId, AssociatedServerMediated associatedServerMediated) throws ApiException {
        return this.createAssociatedServers(authServerId, associatedServerMediated, Collections.emptyMap());
    }

    public List<AuthorizationServer> createAssociatedServers(String authServerId, AssociatedServerMediated associatedServerMediated, Map<String, String> additionalHeaders) throws ApiException {
        AssociatedServerMediated localVarPostBody = associatedServerMediated;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAssociatedServers");
        }
        if (associatedServerMediated == null) {
            throw new ApiException(400, "Missing the required parameter 'associatedServerMediated' when calling createAssociatedServers");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAssociatedServer(String authServerId, String associatedServerId) throws ApiException {
        this.deleteAssociatedServer(authServerId, associatedServerId, Collections.emptyMap());
    }

    public void deleteAssociatedServer(String authServerId, String associatedServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAssociatedServer");
        }
        if (associatedServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'associatedServerId' when calling deleteAssociatedServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers/{associatedServerId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{associatedServerId\\}", this.apiClient.escapeString(associatedServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q, Integer limit, String after) throws ApiException {
        return this.listAssociatedServersByTrustedType(authServerId, trusted, q, limit, after, Collections.emptyMap());
    }

    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q, Integer limit, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAssociatedServersByTrustedType");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("trusted", trusted));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

