/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.Csr;
import com.okta.sdk.resource.model.CsrMetadata;
import com.okta.sdk.resource.model.IdentityProvider;
import com.okta.sdk.resource.model.IdentityProviderApplicationUser;
import com.okta.sdk.resource.model.JsonWebKey;
import com.okta.sdk.resource.model.SocialAuthToken;
import com.okta.sdk.resource.model.UserIdentityProviderLinkRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class IdentityProviderApi {
    private ApiClient apiClient;

    public IdentityProviderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IdentityProvider activateIdentityProvider(String idpId) throws ApiException {
        return this.activateIdentityProvider(idpId, Collections.emptyMap());
    }

    public IdentityProvider activateIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling activateIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/lifecycle/activate".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey cloneIdentityProviderKey(String idpId, String idpKeyId, String targetIdpId) throws ApiException {
        return this.cloneIdentityProviderKey(idpId, idpKeyId, targetIdpId, Collections.emptyMap());
    }

    public JsonWebKey cloneIdentityProviderKey(String idpId, String idpKeyId, String targetIdpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling cloneIdentityProviderKey");
        }
        if (idpKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpKeyId' when calling cloneIdentityProviderKey");
        }
        if (targetIdpId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetIdpId' when calling cloneIdentityProviderKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{idpKeyId}/clone".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpKeyId\\}", this.apiClient.escapeString(idpKeyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("targetIdpId", targetIdpId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) throws ApiException {
        return this.createIdentityProvider(identityProvider, Collections.emptyMap());
    }

    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider, Map<String, String> additionalHeaders) throws ApiException {
        IdentityProvider localVarPostBody = identityProvider;
        if (identityProvider == null) {
            throw new ApiException(400, "Missing the required parameter 'identityProvider' when calling createIdentityProvider");
        }
        String localVarPath = "/api/v1/idps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey) throws ApiException {
        return this.createIdentityProviderKey(jsonWebKey, Collections.emptyMap());
    }

    public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey, Map<String, String> additionalHeaders) throws ApiException {
        JsonWebKey localVarPostBody = jsonWebKey;
        if (jsonWebKey == null) {
            throw new ApiException(400, "Missing the required parameter 'jsonWebKey' when calling createIdentityProviderKey");
        }
        String localVarPath = "/api/v1/idps/credentials/keys";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProvider deactivateIdentityProvider(String idpId) throws ApiException {
        return this.deactivateIdentityProvider(idpId, Collections.emptyMap());
    }

    public IdentityProvider deactivateIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling deactivateIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/lifecycle/deactivate".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteIdentityProvider(String idpId) throws ApiException {
        this.deleteIdentityProvider(idpId, Collections.emptyMap());
    }

    public void deleteIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling deleteIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteIdentityProviderKey(String idpKeyId) throws ApiException {
        this.deleteIdentityProviderKey(idpKeyId, Collections.emptyMap());
    }

    public void deleteIdentityProviderKey(String idpKeyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpKeyId' when calling deleteIdentityProviderKey");
        }
        String localVarPath = "/api/v1/idps/credentials/keys/{idpKeyId}".replaceAll("\\{idpKeyId\\}", this.apiClient.escapeString(idpKeyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Csr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata) throws ApiException {
        return this.generateCsrForIdentityProvider(idpId, metadata, Collections.emptyMap());
    }

    public Csr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata, Map<String, String> additionalHeaders) throws ApiException {
        CsrMetadata localVarPostBody = metadata;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
        }
        if (metadata == null) {
            throw new ApiException(400, "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Csr> localVarReturnType = new TypeReference<Csr>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey generateIdentityProviderSigningKey(String idpId, Integer validityYears) throws ApiException {
        return this.generateIdentityProviderSigningKey(idpId, validityYears, Collections.emptyMap());
    }

    public JsonWebKey generateIdentityProviderSigningKey(String idpId, Integer validityYears, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling generateIdentityProviderSigningKey");
        }
        if (validityYears == null) {
            throw new ApiException(400, "Missing the required parameter 'validityYears' when calling generateIdentityProviderSigningKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/generate".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("validityYears", validityYears));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Csr getCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        return this.getCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    public Csr getCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling getCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Csr> localVarReturnType = new TypeReference<Csr>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProvider getIdentityProvider(String idpId) throws ApiException {
        return this.getIdentityProvider(idpId, Collections.emptyMap());
    }

    public IdentityProvider getIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId) throws ApiException {
        return this.getIdentityProviderApplicationUser(idpId, userId, Collections.emptyMap());
    }

    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProviderApplicationUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getIdentityProviderApplicationUser");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey getIdentityProviderKey(String idpKeyId) throws ApiException {
        return this.getIdentityProviderKey(idpKeyId, Collections.emptyMap());
    }

    public JsonWebKey getIdentityProviderKey(String idpKeyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpKeyId' when calling getIdentityProviderKey");
        }
        String localVarPath = "/api/v1/idps/credentials/keys/{idpKeyId}".replaceAll("\\{idpKeyId\\}", this.apiClient.escapeString(idpKeyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey getIdentityProviderSigningKey(String idpId, String idpKeyId) throws ApiException {
        return this.getIdentityProviderSigningKey(idpId, idpKeyId, Collections.emptyMap());
    }

    public JsonWebKey getIdentityProviderSigningKey(String idpId, String idpKeyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProviderSigningKey");
        }
        if (idpKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpKeyId' when calling getIdentityProviderSigningKey");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{idpKeyId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpKeyId\\}", this.apiClient.escapeString(idpKeyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws ApiException {
        return this.linkUserToIdentityProvider(idpId, userId, userIdentityProviderLinkRequest, Collections.emptyMap());
    }

    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest, Map<String, String> additionalHeaders) throws ApiException {
        UserIdentityProviderLinkRequest localVarPostBody = userIdentityProviderLinkRequest;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
        }
        if (userIdentityProviderLinkRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Csr> listCsrsForIdentityProvider(String idpId) throws ApiException {
        return this.listCsrsForIdentityProvider(idpId, Collections.emptyMap());
    }

    public List<Csr> listCsrsForIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listCsrsForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Csr>> localVarReturnType = new TypeReference<List<Csr>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q, String after, Integer limit, String expand) throws ApiException {
        return this.listIdentityProviderApplicationUsers(idpId, q, after, limit, expand, Collections.emptyMap());
    }

    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q, String after, Integer limit, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listIdentityProviderApplicationUsers");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentityProviderApplicationUser>> localVarReturnType = new TypeReference<List<IdentityProviderApplicationUser>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JsonWebKey> listIdentityProviderKeys(String after, Integer limit) throws ApiException {
        return this.listIdentityProviderKeys(after, limit, Collections.emptyMap());
    }

    public List<JsonWebKey> listIdentityProviderKeys(String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/idps/credentials/keys";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JsonWebKey> listIdentityProviderSigningKeys(String idpId) throws ApiException {
        return this.listIdentityProviderSigningKeys(idpId, Collections.emptyMap());
    }

    public List<JsonWebKey> listIdentityProviderSigningKeys(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listIdentityProviderSigningKeys");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentityProvider> listIdentityProviders(String q, String after, Integer limit, String type) throws ApiException {
        return this.listIdentityProviders(q, after, limit, type, Collections.emptyMap());
    }

    public List<IdentityProvider> listIdentityProviders(String q, String after, Integer limit, String type, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/idps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentityProvider>> localVarReturnType = new TypeReference<List<IdentityProvider>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId) throws ApiException {
        return this.listSocialAuthTokens(idpId, userId, Collections.emptyMap());
    }

    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listSocialAuthTokens");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSocialAuthTokens");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}/credentials/tokens".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<SocialAuthToken>> localVarReturnType = new TypeReference<List<SocialAuthToken>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey publishCsrForIdentityProvider(String idpId, String idpCsrId, File body) throws ApiException {
        return this.publishCsrForIdentityProvider(idpId, idpCsrId, body, Collections.emptyMap());
    }

    public JsonWebKey publishCsrForIdentityProvider(String idpId, String idpCsrId, File body, Map<String, String> additionalHeaders) throws ApiException {
        File localVarPostBody = body;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling publishCsrForIdentityProvider");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}/lifecycle/publish".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProvider replaceIdentityProvider(String idpId, IdentityProvider identityProvider) throws ApiException {
        return this.replaceIdentityProvider(idpId, identityProvider, Collections.emptyMap());
    }

    public IdentityProvider replaceIdentityProvider(String idpId, IdentityProvider identityProvider, Map<String, String> additionalHeaders) throws ApiException {
        IdentityProvider localVarPostBody = identityProvider;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling replaceIdentityProvider");
        }
        if (identityProvider == null) {
            throw new ApiException(400, "Missing the required parameter 'identityProvider' when calling replaceIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        this.revokeCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling revokeCsrForIdentityProvider");
        }
        if (idpCsrId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpCsrId' when calling revokeCsrForIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{idpCsrId\\}", this.apiClient.escapeString(idpCsrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unlinkUserFromIdentityProvider(String idpId, String userId) throws ApiException {
        this.unlinkUserFromIdentityProvider(idpId, userId, Collections.emptyMap());
    }

    public void unlinkUserFromIdentityProvider(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling unlinkUserFromIdentityProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unlinkUserFromIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

