/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"expression", "timezone"})
public class ImportScheduleSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public ImportScheduleSettings expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="00 21 * * Mon,Thu,Fri,Sat", required=true, value="The import schedule in UNIX cron format")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ImportScheduleSettings timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="America/Los_Angeles", value="The import schedule time zone in Internet Assigned Numbers Authority (IANA) time zone name format")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportScheduleSettings importScheduleSettings = (ImportScheduleSettings)o;
        return Objects.equals(this.expression, importScheduleSettings.expression) && Objects.equals(this.timezone, importScheduleSettings.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportScheduleSettings {\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

