/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the necessary properties for a dynamic Windows version requirement")
@JsonPropertyOrder(value={"type", "distanceFromLatestMajor", "latestSecurityPatch"})
@JsonTypeName(value="OSVersionConstraint_dynamicVersionRequirement")
public class OSVersionConstraintDynamicVersionRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_DISTANCE_FROM_LATEST_MAJOR = "distanceFromLatestMajor";
    private Integer distanceFromLatestMajor;
    public static final String JSON_PROPERTY_LATEST_SECURITY_PATCH = "latestSecurityPatch";
    private Boolean latestSecurityPatch;

    public OSVersionConstraintDynamicVersionRequirement type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the type of the dynamic Windows version requirement")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OSVersionConstraintDynamicVersionRequirement distanceFromLatestMajor(Integer distanceFromLatestMajor) {
        this.distanceFromLatestMajor = distanceFromLatestMajor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the distance from the latest Windows major version")
    @JsonProperty(value="distanceFromLatestMajor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDistanceFromLatestMajor() {
        return this.distanceFromLatestMajor;
    }

    @JsonProperty(value="distanceFromLatestMajor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDistanceFromLatestMajor(Integer distanceFromLatestMajor) {
        this.distanceFromLatestMajor = distanceFromLatestMajor;
    }

    public OSVersionConstraintDynamicVersionRequirement latestSecurityPatch(Boolean latestSecurityPatch) {
        this.latestSecurityPatch = latestSecurityPatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the policy requires Windows devices to be on the latest security patch")
    @JsonProperty(value="latestSecurityPatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLatestSecurityPatch() {
        return this.latestSecurityPatch;
    }

    @JsonProperty(value="latestSecurityPatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestSecurityPatch(Boolean latestSecurityPatch) {
        this.latestSecurityPatch = latestSecurityPatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSVersionConstraintDynamicVersionRequirement osVersionConstraintDynamicVersionRequirement = (OSVersionConstraintDynamicVersionRequirement)o;
        return Objects.equals((Object)this.type, (Object)osVersionConstraintDynamicVersionRequirement.type) && Objects.equals(this.distanceFromLatestMajor, osVersionConstraintDynamicVersionRequirement.distanceFromLatestMajor) && Objects.equals(this.latestSecurityPatch, osVersionConstraintDynamicVersionRequirement.latestSecurityPatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.distanceFromLatestMajor, this.latestSecurityPatch});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersionConstraintDynamicVersionRequirement {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    distanceFromLatestMajor: ").append(this.toIndentedString(this.distanceFromLatestMajor)).append("\n");
        sb.append("    latestSecurityPatch: ").append(this.toIndentedString(this.latestSecurityPatch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MINIMUM("MINIMUM"),
        EXACT("EXACT"),
        EXACT_ANY_SUPPORTED("EXACT_ANY_SUPPORTED"),
        NOT_ALLOWED("NOT_ALLOWED"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

