/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Pin Request")
@JsonPropertyOrder(value={"authenticatorEnrollmentId", "fulfillmentProvider", "userId"})
public class PinRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public PinRequest authenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID for a WebAuthn Preregistration Factor in Okta")
    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthenticatorEnrollmentId() {
        return this.authenticatorEnrollmentId;
    }

    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public PinRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public PinRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinRequest pinRequest = (PinRequest)o;
        return Objects.equals(this.authenticatorEnrollmentId, pinRequest.authenticatorEnrollmentId) && Objects.equals((Object)this.fulfillmentProvider, (Object)pinRequest.fulfillmentProvider) && Objects.equals(this.userId, pinRequest.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticatorEnrollmentId, this.fulfillmentProvider, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PinRequest {\n");
        sb.append("    authenticatorEnrollmentId: ").append(this.toIndentedString(this.authenticatorEnrollmentId)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO("yubico"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

