/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies a secret question and answer that's validated (case insensitive) when a user forgets their password or unlocks their account. The answer property is write-only.")
@JsonPropertyOrder(value={"answer", "question"})
public class RecoveryQuestionCredential
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;
    public static final String JSON_PROPERTY_QUESTION = "question";
    private String question;

    public RecoveryQuestionCredential answer(String answer) {
        this.answer = answer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The recovery question answer")
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public RecoveryQuestionCredential question(String question) {
        this.question = question;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The recovery question")
    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuestion() {
        return this.question;
    }

    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuestion(String question) {
        this.question = question;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveryQuestionCredential recoveryQuestionCredential = (RecoveryQuestionCredential)o;
        return Objects.equals(this.answer, recoveryQuestionCredential.answer) && Objects.equals(this.question, recoveryQuestionCredential.question);
    }

    public int hashCode() {
        return Objects.hash(this.answer, this.question);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecoveryQuestionCredential {\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("    question: ").append(this.toIndentedString(this.question)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

